/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.libreoffice.ide.eclipse.core.LogLevels;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;

public class PluginLogger {
    private static LogLevels sLevel = LogLevels.DEBUG;

    public static void debug(String string, Throwable throwable) {
        if (sLevel.equals((Object)LogLevels.DEBUG)) {
            if (string == null && throwable != null) {
                string = PluginLogger.getStackTrace(throwable);
            }
            OOEclipsePlugin.getDefault().getLog().log((IStatus)new Status(0, OOEclipsePlugin.getDefault().getBundle().getSymbolicName(), 0, string, throwable));
        }
    }

    public static void debug(String string) {
        PluginLogger.debug(string, null);
    }

    public static void info(String string) {
        if (sLevel.equals((Object)LogLevels.DEBUG) || sLevel.equals((Object)LogLevels.INFO)) {
            OOEclipsePlugin.getDefault().getLog().log((IStatus)new Status(1, OOEclipsePlugin.getDefault().getBundle().getSymbolicName(), 1, string, null));
        }
    }

    public static void warning(String string) {
        PluginLogger.warning(string, null);
    }

    public static void warning(String string, Throwable throwable) {
        if (!sLevel.equals((Object)LogLevels.ERROR)) {
            if (string == null && throwable != null) {
                string = PluginLogger.getStackTrace(throwable);
            }
            OOEclipsePlugin.getDefault().getLog().log((IStatus)new Status(2, OOEclipsePlugin.getDefault().getBundle().getSymbolicName(), 2, string, throwable));
        }
    }

    public static void error(String string, Throwable throwable) {
        if (string == null && throwable != null) {
            string = PluginLogger.getStackTrace(throwable);
        }
        OOEclipsePlugin.getDefault().getLog().log((IStatus)new Status(4, OOEclipsePlugin.getDefault().getBundle().getSymbolicName(), 4, string, throwable));
    }

    public static void error(String string) {
        PluginLogger.error(string, null);
    }

    public static void setLevel(LogLevels logLevels) {
        sLevel = logLevels;
    }

    public static boolean isLevel(LogLevels logLevels) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = logLevels.equals((Object)LogLevels.WARNING) && !sLevel.equals((Object)LogLevels.ERROR);
        boolean bl4 = logLevels.equals((Object)LogLevels.INFO) && (sLevel.equals((Object)LogLevels.DEBUG) || sLevel.equals((Object)LogLevels.INFO));
        boolean bl5 = bl = logLevels.equals((Object)LogLevels.DEBUG) && sLevel.equals((Object)LogLevels.DEBUG);
        if (logLevels.equals((Object)LogLevels.ERROR) || bl3 || bl4 || bl) {
            bl2 = true;
        }
        return bl2;
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

