/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.libreoffice.ide.eclipse.core.Messages;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;

public class ResourceChangesHandler
implements IStartup,
IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResource iResource;
        if (1 == iResourceChangeEvent.getType()) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            for (IResourceDelta iResourceDelta2 : iResourceDelta.getAffectedChildren()) {
                IResource iResource2 = iResourceDelta2.getResource();
                IProject iProject = iResource2.getProject();
                if (ProjectsManager.getProject(iProject.getName()) != null || !iProject.isOpen()) continue;
                ProjectAdderJob projectAdderJob = new ProjectAdderJob(iProject);
                projectAdderJob.schedule();
            }
        } else if (4 == iResourceChangeEvent.getType()) {
            IResource iResource3 = iResourceChangeEvent.getResource();
            if (ProjectsManager.getProject(iResource3.getName()) != null) {
                ProjectsManager.removeProject(iResource3.getName());
            }
        } else if (2 == iResourceChangeEvent.getType() && (iResource = iResourceChangeEvent.getResource()) != null && ProjectsManager.getProject(iResource.getName()) != null) {
            ProjectsManager.removeProject(iResource.getName());
        }
    }

    public void earlyStartup() {
        ProjectsManager.load();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        PluginLogger.info("Resources changes are now listened");
    }

    private class ProjectAdderJob
    extends WorkspaceJob {
        private IProject mPrj;

        public ProjectAdderJob(IProject iProject) {
            super(Messages.getString("ResourceChangesHandler.Title"));
            this.mPrj = iProject;
        }

        public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
            ProjectsManager.addProject(this.mPrj);
            return Status.OK_STATUS;
        }
    }
}

