/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.utils.WorkbenchHelper;

public abstract class AbstractPulldownAction
implements IWorkbenchWindowPulldownDelegate {
    private String mParameterName = "";

    public AbstractPulldownAction(String string) {
        this.mParameterName = string;
    }

    public abstract boolean isValidSelection(IStructuredSelection var1);

    protected void openWizard(INewWizard iNewWizard) {
        if (this.isValidSelection(this.getSelection())) {
            Shell shell = Display.getDefault().getActiveShell();
            iNewWizard.init(PlatformUI.getWorkbench(), this.getSelection());
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)iNewWizard);
            wizardDialog.create();
            this.centerOnScreen(wizardDialog);
            wizardDialog.open();
        }
    }

    public Menu getMenu(Control control) {
        Menu menu;
        MenuManager menuManager = new MenuManager();
        for (Action action : menu = this.getActionsFromConfig()) {
            menuManager.add((IAction)action);
        }
        Menu menu2 = menuManager.createContextMenu(control);
        return menu2;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private Action[] getActionsFromConfig() {
        ArrayList<OpenUnoProjectWizardAction> arrayList = new ArrayList<OpenUnoProjectWizardAction>();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "newWizards");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                if (!iConfigurationElement.getName().equals("wizard") || !this.isCorrectWizard(iConfigurationElement)) continue;
                arrayList.add(new OpenUnoProjectWizardAction(iConfigurationElement));
            }
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private boolean isCorrectWizard(IConfigurationElement iConfigurationElement) {
        boolean bl = false;
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("class");
        if (iConfigurationElementArray.length > 0) {
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[i].getChildren("parameter");
                for (int j = 0; j < iConfigurationElementArray2.length; ++j) {
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[j];
                    if (!this.mParameterName.equals(iConfigurationElement2.getAttribute("name"))) continue;
                    bl = Boolean.valueOf(iConfigurationElement2.getAttribute("value"));
                }
            }
        }
        if (Boolean.valueOf(iConfigurationElement.getAttribute("unoproject")).booleanValue()) {
            bl = true;
        }
        return bl;
    }

    private IStructuredSelection getSelection() {
        ISelection iSelection;
        StructuredSelection structuredSelection = StructuredSelection.EMPTY;
        IWorkbenchWindow iWorkbenchWindow = WorkbenchHelper.getActivePage().getWorkbenchWindow();
        if (iWorkbenchWindow != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)iSelection;
        }
        return structuredSelection;
    }

    private void centerOnScreen(WizardDialog wizardDialog) {
        Shell shell = wizardDialog.getShell();
        Point point = shell.getSize();
        Rectangle rectangle = Display.getDefault().getBounds();
        int n = (rectangle.width - point.y) / 2;
        int n2 = (rectangle.height - point.y) / 2;
        Rectangle rectangle2 = new Rectangle(n, n2, point.x, point.y);
        shell.setBounds(rectangle2);
    }

    private class OpenUnoProjectWizardAction
    extends Action {
        private IConfigurationElement mConfigurationElement;

        public OpenUnoProjectWizardAction(IConfigurationElement iConfigurationElement) {
            this.mConfigurationElement = iConfigurationElement;
            this.setText(iConfigurationElement.getAttribute("name"));
            String string = this.getDescriptionFromConfig(this.mConfigurationElement);
            this.setDescription(string);
            this.setToolTipText(string);
            this.setImageDescriptor(this.getIconFromConfig(this.mConfigurationElement));
        }

        private String getDescriptionFromConfig(IConfigurationElement iConfigurationElement) {
            String string = "";
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("description");
            if (iConfigurationElementArray.length >= 1) {
                string = iConfigurationElementArray[0].getValue();
            }
            return string;
        }

        private ImageDescriptor getIconFromConfig(IConfigurationElement iConfigurationElement) {
            ImageDescriptor imageDescriptor = null;
            String string = iConfigurationElement.getAttribute("icon");
            if (string != null) {
                imageDescriptor = OOEclipsePlugin.getDefault().getImageManager().getImageDescriptorFromPath(string);
            }
            return imageDescriptor;
        }

        private INewWizard createWizard() throws CoreException {
            return (INewWizard)this.mConfigurationElement.createExecutableExtension("class");
        }

        public void run() {
            try {
                AbstractPulldownAction.this.openWizard(this.createWizard());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

