/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.actions.Messages;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.pack.PackagePropertiesModel;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;
import org.libreoffice.plugin.core.model.ManifestModel;
import org.libreoffice.plugin.core.model.UnoPackage;

public class ConvertToManifestAction
implements IObjectActionDelegate {
    private IFile mPackageFile;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IAction iAction) {
        PackagePropertiesModel packagePropertiesModel = new PackagePropertiesModel(this.mPackageFile);
        String string = this.mPackageFile.getProject().getName();
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string);
        File file = SystemHelper.getFile(iUnoidlProject);
        UnoPackage unoPackage = UnoidlProjectHelper.createMinimalUnoPackage(iUnoidlProject, new File("foo.oxt"));
        ManifestModel manifestModel = unoPackage.getManifestModel();
        this.setManifestModel(packagePropertiesModel, file, manifestModel);
        IFile iFile = this.mPackageFile.getParent().getFile((IPath)new Path("manifest.xml"));
        File file2 = new File(iFile.getLocationURI());
        if (!file2.exists() || file2.canWrite()) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                manifestModel.write(fileOutputStream);
            }
            catch (Exception exception) {
                PluginLogger.error(Messages.getString("ConvertToManifestAction.WriteError0"), exception);
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                iFile.refreshLocal(0, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void setManifestModel(PackagePropertiesModel packagePropertiesModel, File file, ManifestModel manifestModel) {
        for (IFolder object : packagePropertiesModel.getBasicLibraries()) {
            manifestModel.addBasicLibrary(object.getProjectRelativePath().toString());
        }
        for (IFolder iFolder : packagePropertiesModel.getDialogLibraries()) {
            manifestModel.addDialogLibrary(iFolder.getProjectRelativePath().toString());
        }
        for (IResource iResource : packagePropertiesModel.getContents()) {
            File file2 = SystemHelper.getFile(iResource);
            manifestModel.addContent(UnoPackage.getPathRelativeToBase(file2, file), file2);
        }
        for (Map.Entry entry : packagePropertiesModel.getDescriptionFiles().entrySet()) {
            manifestModel.addDescription(((IFile)entry.getValue()).getProjectRelativePath().toString(), (Locale)entry.getKey());
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof IFile) {
            this.mPackageFile = (IFile)object;
        }
    }
}

