/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.builders;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.TypesBuilder;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;

public class IdlcBuildVisitor
implements IResourceVisitor {
    private static String sExtension = "idl";
    private IProgressMonitor mProgressMonitor;
    private IUnoidlProject mProject;
    private String mPath;

    public IdlcBuildVisitor(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        this.mProgressMonitor = iProgressMonitor;
        this.mProject = iUnoidlProject;
        this.mPath = this.mProject.getIdlPath().toString();
    }

    public boolean visit(IResource iResource) {
        boolean bl = false;
        boolean bl2 = iResource.getProjectRelativePath().toString().startsWith(this.mPath);
        if (bl2 && iResource.getType() == 1 && sExtension.equalsIgnoreCase(iResource.getFileExtension())) {
            TypesBuilder.runIdlcOnFile((IFile)iResource, this.mProject, this.mProgressMonitor);
            if (this.mProgressMonitor != null) {
                this.mProgressMonitor.worked(1);
            }
        } else if (bl2 && iResource.getType() == 2) {
            bl = true;
        } else {
            PluginLogger.debug("Non handled resource");
        }
        this.mProgressMonitor = null;
        return bl;
    }
}

