/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.builders;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.Messages;

public class IdlcErrorReader {
    private static final String R_IDLCPP_ERROR = "cpp: (\\S+):([0-9]+)(.*:[0-9]+)? (.*)";
    private static final String R_IDLC_ERROR = "(.*):([0-9]+) \\[([0-9]+):([0-9]+)\\] : (WARNING, )?(.*)";
    private static final int IDLC_ERROR_LINE_GROUP = 2;
    private static final int IDLC_ERROR_OFFSET_START_GROUP = 3;
    private static final int IDLC_ERROR_OFFSET_END_GROUP = 4;
    private static final int IDLC_ERROR_MESSAGE_GROUP = 5;
    private static final int IDLCPP_INCLUDE_PATH_GROUP = 4;
    private static final int IDLCPP_OPTIONAL_GROUP = 3;
    private LineNumberReader mReader;
    private InputStreamReader mIn;
    private IFile mCompiledFile;

    public IdlcErrorReader(InputStream inputStream, IFile iFile) {
        this.mIn = new InputStreamReader(inputStream);
        this.mReader = new LineNumberReader(this.mIn);
        this.mCompiledFile = iFile;
    }

    public void readErrors() {
        try {
            this.mCompiledFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            String string = this.mReader.readLine();
            while (null != string) {
                IMarker iMarker = this.analyseIdlcppError(string);
                if (null == iMarker) {
                    iMarker = this.analyseIdlcError(string);
                }
                if (null != iMarker && 1 == iMarker.getResource().getType() && !iMarker.getResource().getProjectRelativePath().toString().equals(this.mCompiledFile.getProjectRelativePath().toString())) {
                    iMarker.delete();
                }
                string = this.mReader.readLine();
            }
        }
        catch (IOException iOException) {
            PluginLogger.error(Messages.getString("IdlcErrorReader.ErrorReadingError"), iOException);
        }
        catch (CoreException coreException) {
            PluginLogger.error(Messages.getString("IdlcErrorReader.MarkerCreationError") + this.mCompiledFile.getProjectRelativePath().toString(), coreException);
        }
        finally {
            try {
                this.mReader.close();
                this.mIn.close();
            }
            catch (IOException iOException) {}
        }
    }

    private IMarker analyseIdlcError(String string) {
        IMarker iMarker = null;
        Pattern pattern = Pattern.compile(R_IDLC_ERROR);
        Matcher matcher = pattern.matcher(string);
        if (!string.startsWith("idlc:") && matcher.matches()) {
            IProject iProject = this.mCompiledFile.getProject();
            boolean bl = false;
            if (null == matcher.group(5)) {
                bl = true;
            }
            String string2 = matcher.group(1);
            int n = Integer.parseInt(matcher.group(2));
            int n2 = Integer.parseInt(matcher.group(3));
            int n3 = Integer.parseInt(matcher.group(4));
            String string3 = matcher.group(matcher.groupCount());
            if (string2.startsWith(iProject.getLocation().toOSString())) {
                int n4 = iProject.getLocation().toOSString().length();
                string2 = string2.substring(n4);
            }
            IFile iFile = iProject.getFile(string2);
            try {
                int n5 = 1;
                if (bl) {
                    n5 = 2;
                }
                iMarker = iFile.createMarker("org.eclipse.core.resources.problemmarker");
                iMarker.setAttribute("severity", n5);
                iMarker.setAttribute("message", (Object)string3);
                iMarker.setAttribute("lineNumber", n);
                iMarker.setAttribute("priority", 1);
                int n6 = this.getLineOffset(n);
                iMarker.setAttribute("charStart", n6 + n2 - 1);
                iMarker.setAttribute("charEnd", n6 + n3);
            }
            catch (CoreException coreException) {
                PluginLogger.error(Messages.getString("IdlcErrorReader.MarkerCreationError") + iFile.getProjectRelativePath().toString(), coreException);
            }
        }
        return iMarker;
    }

    private IMarker analyseIdlcppError(String string) {
        IMarker iMarker = null;
        Pattern pattern = Pattern.compile(R_IDLCPP_ERROR);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            IProject iProject = this.mCompiledFile.getProject();
            String string2 = matcher.group(1);
            int n = Integer.parseInt(matcher.group(2));
            String string3 = matcher.group(4);
            if (null == matcher.group(3)) {
                IFile iFile = string2.startsWith(".") ? iProject.getFile(string2) : this.mCompiledFile;
                String string4 = "idlcpp error: " + string3;
                try {
                    iMarker = iFile.createMarker("org.eclipse.core.resources.problemmarker");
                    iMarker.setAttribute("severity", 2);
                    iMarker.setAttribute("message", (Object)string4);
                    iMarker.setAttribute("lineNumber", n);
                    iMarker.setAttribute("priority", 2);
                    int n2 = this.getLineOffset(n);
                    iMarker.setAttribute("charStart", n2);
                    iMarker.setAttribute("charEnd", n2 + this.getLineLength(n));
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return iMarker;
    }

    private int getLineOffset(int n) {
        int n2 = 0;
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.mCompiledFile.getContents()));
            int n3 = n - 1;
            for (int i = 0; i < n3; ++i) {
                String string = lineNumberReader.readLine();
                n2 += string.length() + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    private int getLineLength(int n) {
        int n2 = 0;
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.mCompiledFile.getContents()));
            int n3 = n - 1;
            for (int i = 0; i < n3; ++i) {
                lineNumberReader.readLine();
            }
            String string = lineNumberReader.readLine();
            n2 = string.length();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }
}

