/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.builders;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.IFileVisitor;
import org.libreoffice.ide.eclipse.core.builders.IdlwBuilder;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;

public class IdlwBuildVisitor
implements IFileVisitor {
    private static String sExtension = ".idl";
    private IProgressMonitor mProgressMonitor;
    private IUnoidlProject mProject;
    private String mPath;

    public IdlwBuildVisitor(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        this.mProgressMonitor = iProgressMonitor;
        this.mProject = iUnoidlProject;
        this.mPath = iUnoidlProject.getProjectPath().append("/idl").toOSString();
    }

    @Override
    public boolean visit(File file) {
        boolean bl = false;
        boolean bl2 = file.getAbsolutePath().startsWith(this.mPath);
        if (bl2 && file.isFile() && file.getName().endsWith(sExtension)) {
            IdlwBuilder.runIdlwOnFile(file, this.mProject, this.mProgressMonitor);
            if (this.mProgressMonitor != null) {
                this.mProgressMonitor.worked(1);
            }
        } else if (bl2 && file.isDirectory()) {
            bl = true;
        } else {
            PluginLogger.debug("Non handled resource");
        }
        this.mProgressMonitor = null;
        return bl;
    }
}

