/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.builders;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.libreoffice.ide.eclipse.core.builders.IdlwBuildVisitor;
import org.libreoffice.ide.eclipse.core.builders.VisitableFile;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.plugin.core.utils.FileHelper;

public class IdlwBuilder {
    public static void build(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) throws Exception {
        IFile iFile = iUnoidlProject.getFile(iUnoidlProject.getTypesPath());
        File file = iUnoidlProject.getProjectPath().append(iFile.getProjectRelativePath()).toFile();
        if (file != null && file.exists()) {
            FileHelper.remove(file);
        }
        IFolder iFolder = iUnoidlProject.getFolder(iUnoidlProject.getIdlPath());
        IPath iPath = iUnoidlProject.getProjectPath().append(iFolder.getProjectRelativePath());
        File file2 = iPath.toFile();
        VisitableFile visitableFile = new VisitableFile(file2);
        visitableFile.accept(new IdlwBuildVisitor(iUnoidlProject, iProgressMonitor));
    }

    static void runIdlwOnFile(File file, IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        ISdk iSdk = iUnoidlProject.getSdk();
        if (null != iSdk) {
            String string = iSdk.getCommand("unoidl-write") + " \"";
            IPath iPath = iUnoidlProject.getProjectPath().append(iUnoidlProject.getIdlPath().toString());
            IPath iPath2 = iUnoidlProject.getProjectPath().append(iUnoidlProject.getTypesPath().toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : iUnoidlProject.getOOo().getTypesPath()) {
                arrayList.add(string2);
            }
            arrayList.add(file.getAbsolutePath());
            arrayList.add(iPath.toOSString());
            arrayList.add(iPath2.toOSString());
            string = string + String.join((CharSequence)"\" \"", arrayList.toArray(new String[0]));
            string = string + "\"";
            Process process = iSdk.runTool(iUnoidlProject, string, iProgressMonitor);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

