/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.builders;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.IFileVisitor;
import org.libreoffice.ide.eclipse.core.builders.RegmergeBuilder;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;

public class RegmergeBuildVisitor
implements IFileVisitor {
    private static String sExtension = ".urd";
    private IProgressMonitor mProgressMonitor;
    private IUnoidlProject mProject;
    private String mPath;

    public RegmergeBuildVisitor(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        this.mProgressMonitor = iProgressMonitor;
        this.mProject = iUnoidlProject;
        this.mPath = iUnoidlProject.getProjectPath().append(this.mProject.getUrdPath().toString()).toOSString();
    }

    @Override
    public boolean visit(File file) {
        boolean bl = false;
        boolean bl2 = file.getAbsolutePath().startsWith(this.mPath);
        if (bl2 && file.isFile() && file.getName().endsWith(sExtension)) {
            RegmergeBuilder.runRegmergeOnFile(file, this.mProject, this.mProgressMonitor);
            if (this.mProgressMonitor != null) {
                this.mProgressMonitor.worked(1);
            }
        } else if (bl2 && file.isDirectory()) {
            bl = true;
        } else {
            PluginLogger.debug("Non handled resource");
        }
        this.mProgressMonitor = null;
        return bl;
    }
}

