/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.builders;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.libreoffice.ide.eclipse.core.builders.RegmergeBuildVisitor;
import org.libreoffice.ide.eclipse.core.builders.VisitableFile;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.plugin.core.utils.FileHelper;

public class RegmergeBuilder {
    public static final String TYPE_ROOT_KEY = "/UCR";

    public static void build(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) throws Exception {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        IFile iFile = iUnoidlProject.getFile(iUnoidlProject.getTypesPath());
        File file = iProject.getLocation().append(iFile.getProjectRelativePath()).toFile();
        if (file != null && file.exists()) {
            FileHelper.remove(file);
        }
        IFolder iFolder = iUnoidlProject.getFolder(iUnoidlProject.getUrdPath());
        IPath iPath = iProject.getLocation().append(iFolder.getProjectRelativePath());
        File file2 = iPath.toFile();
        VisitableFile visitableFile = new VisitableFile(file2);
        visitableFile.accept(new RegmergeBuildVisitor(iUnoidlProject, iProgressMonitor));
    }

    static void runRegmergeOnFile(File file, IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        IFile iFile = iUnoidlProject.getFile(iUnoidlProject.getTypesPath());
        String string = "";
        if (iFile.exists()) {
            string = iFile.getProjectRelativePath().toOSString() + " ";
        }
        String string2 = "regmerge types.rdb /UCR " + string + "\"" + file.getAbsolutePath() + "\"";
        String[] stringArray = iUnoidlProject.getOOo().getBinPath();
        String string3 = "PATH=";
        for (String string4 : stringArray) {
            if (!string3.endsWith("=")) {
                string3 = string3 + System.getProperty("path.separator");
            }
            string3 = string3 + string4;
        }
        Process process = iUnoidlProject.getSdk().runToolWithEnv(iUnoidlProject, string2, new String[]{string3}, iProgressMonitor);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

