/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.builders;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.IdlcBuildVisitor;
import org.libreoffice.ide.eclipse.core.builders.IdlcErrorReader;
import org.libreoffice.ide.eclipse.core.builders.IdlwBuilder;
import org.libreoffice.ide.eclipse.core.builders.Messages;
import org.libreoffice.ide.eclipse.core.builders.RegmergeBuilder;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.ide.eclipse.core.model.language.ILanguageBuilder;

public class TypesBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.libreoffice.ide.eclipse.core.types";
    public static final int IDLW_STATE = 1;
    public static final int IDLC_STATE = 2;
    public static final int REGMERGE_STATE = 3;
    public static final int GENERATE_TYPES_STATE = 4;
    public static final int COMPLETED_STATE = 5;
    public static final int NOT_STARTED_STATE = -1;
    static int sBuildState = -1;
    private boolean mChangedIdl = false;

    protected IProject[] build(int n, Map<String, String> map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.mChangedIdl = false;
        if (sBuildState < 0) {
            IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            if (iResourceDelta != null) {
                this.addVisitor(iResourceDelta);
            } else {
                this.mChangedIdl = true;
            }
            if (this.mChangedIdl && sBuildState < 0) {
                try {
                    TypesBuilder.build(this.getProject(), iProgressMonitor);
                }
                catch (Exception exception) {
                    sBuildState = -1;
                    CoreException coreException = new CoreException((IStatus)new Status(4, "org.libreoffice.ide.eclipse.core", Messages.getString("TypesBuilder.BuildError0"), (Throwable)exception));
                    if (exception instanceof CoreException) {
                        coreException = (CoreException)((Object)exception);
                    }
                    throw coreException;
                }
                sBuildState = -1;
            } else if (sBuildState == 5) {
                sBuildState = -1;
            }
        }
        return null;
    }

    private void addVisitor(IResourceDelta iResourceDelta) throws CoreException {
        iResourceDelta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                boolean bl = false;
                IProject iProject = TypesBuilder.this.getProject();
                IUnoidlProject iUnoidlProject = ProjectsManager.getProject(iProject.getName());
                if (iUnoidlProject != null) {
                    IResource iResource = iResourceDelta.getResource();
                    if (iResource.getType() == 4) {
                        bl = true;
                    } else if (iResource.getType() == 2) {
                        bl = iResource.getProjectRelativePath().toString().startsWith(iUnoidlProject.getIdlDir());
                    } else if (iResource.getType() == 1) {
                        if (iResource.getFileExtension().equals("idl")) {
                            TypesBuilder.this.mChangedIdl = true;
                        } else if (iResource.equals((Object)iUnoidlProject.getTypesFile())) {
                            sBuildState = 5;
                        }
                    }
                }
                return bl;
            }
        });
    }

    public static void build(IProject iProject, IProgressMonitor iProgressMonitor) throws Exception {
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject(iProject.getName());
        TypesBuilder.removeAllRegistries(iProject);
        if (iUnoidlProject.getSdk().useIdlWrite()) {
            sBuildState = 1;
            IdlwBuilder.build(iUnoidlProject, iProgressMonitor);
        } else {
            sBuildState = 2;
            TypesBuilder.buildIdl(iUnoidlProject, iProgressMonitor);
            sBuildState = 3;
            RegmergeBuilder.build(iUnoidlProject, iProgressMonitor);
        }
        sBuildState = 4;
        File file = iProject.getLocation().append(iUnoidlProject.getTypesPath()).toFile();
        File file2 = iProject.getLocation().append(iUnoidlProject.getBuildPath()).toFile();
        ILanguageBuilder iLanguageBuilder = iUnoidlProject.getLanguage().getLanguageBuilder();
        iLanguageBuilder.generateFromTypes(iUnoidlProject.getSdk(), iUnoidlProject.getOOo(), iProject, file, file2, iUnoidlProject.getRootModule(), iProgressMonitor);
        iUnoidlProject.checkManifestTypes();
        iProject.refreshLocal(2, iProgressMonitor);
        sBuildState = -1;
    }

    private static void removeAllRegistries(IProject iProject) {
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject(iProject.getName());
        if (iUnoidlProject == null) {
            return;
        }
        try {
            IPath iPath = iUnoidlProject.getTypesPath();
            IFile iFile = iProject.getFile(iPath);
            if (iFile.exists()) {
                iFile.delete(true, null);
            }
            IPath iPath2 = iUnoidlProject.getUrdPath();
            IFolder iFolder = iProject.getFolder(iPath2);
            for (IResource iResource : iFolder.members()) {
                if (!iResource.exists()) continue;
                iResource.delete(true, null);
            }
        }
        catch (CoreException coreException) {
            PluginLogger.debug(coreException.getMessage());
        }
    }

    public static void buildIdl(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) throws Exception {
        IFolder iFolder = iUnoidlProject.getFolder(iUnoidlProject.getIdlPath());
        if (iFolder.exists()) {
            iFolder.accept((IResourceVisitor)new IdlcBuildVisitor(iUnoidlProject, iProgressMonitor));
        }
    }

    static void runIdlcOnFile(IFile iFile, IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        ISdk iSdk = iUnoidlProject.getSdk();
        if (null != iSdk) {
            if (!iUnoidlProject.getUrdPath().toFile().exists()) {
                iUnoidlProject.getUrdPath().toFile().mkdirs();
            }
            int n = iUnoidlProject.getIdlPath().segmentCount();
            IPath iPath = iFile.getProjectRelativePath().removeLastSegments(1).removeFirstSegments(n);
            Path path = new Path(iSdk.getHome());
            String string = "{0} -O \"{1}\" -I \"{2}\" -I \"{3}\" \"{4}\"";
            String string2 = MessageFormat.format(string, iSdk.getCommand("idlc"), iUnoidlProject.getUrdPath().append(iPath).toOSString(), path.append("idl").toOSString(), iUnoidlProject.getIdlPath().toOSString(), iFile.getProjectRelativePath().toOSString());
            Process process = iSdk.runTool(iUnoidlProject, string2, iProgressMonitor);
            IdlcErrorReader idlcErrorReader = new IdlcErrorReader(process.getErrorStream(), iFile);
            idlcErrorReader.readErrors();
        }
    }
}

