/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionFormPage;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionSourcePage;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionHandler;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptionEditor
extends FormEditor {
    private DescriptionSourcePage mSourcePage;
    private DescriptionFormPage mFormPage;
    private DescriptionModel mDescriptionModel;

    protected void addPages() {
        try {
            this.mFormPage = new DescriptionFormPage(this, "form");
            this.addPage((IFormPage)this.mFormPage);
            this.mFormPage.setModel(this.getDescriptionModel());
            this.mSourcePage = new DescriptionSourcePage(this, "description", "source");
            this.mSourcePage.init(this.getEditorSite(), this.getEditorInput());
            this.addPage(this.mSourcePage);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            this.setPartName(iFileEditorInput.getName());
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", true);
                sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                DescriptionHandler descriptionHandler = new DescriptionHandler(this.getDescriptionModel());
                File file = new File(iFileEditorInput.getFile().getLocationURI().getPath());
                this.getDescriptionModel().setSuspendEvent(true);
                sAXParser.parse(file, (DefaultHandler)descriptionHandler);
            }
            catch (Exception exception) {
                PluginLogger.error(Messages.getString("PackagePropertiesEditor.DescriptionParseError"), exception);
            }
        }
    }

    public boolean isDirty() {
        return this.mDescriptionModel.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor iProgressMonitor) {
        OutputStream outputStream = null;
        try {
            FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
            File file = new File(fileEditorInput.getFile().getLocationURI());
            outputStream = new FileOutputStream(file);
            this.getDescriptionModel().serialize(outputStream);
            fileEditorInput.getFile().refreshLocal(0, iProgressMonitor);
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("DescriptionEditor.ErrorSaving"), exception);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            this.mSourcePage.doRevertToSaved();
            this.mFormPage.reloadData();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public DescriptionModel getDescriptionModel() {
        if (this.mDescriptionModel == null) {
            this.mDescriptionModel = new DescriptionModel();
        }
        return this.mDescriptionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDescrToSource() {
        TextFileDocumentProvider textFileDocumentProvider;
        IDocument iDocument;
        if (this.mSourcePage.getDocumentProvider() instanceof TextFileDocumentProvider && (iDocument = (textFileDocumentProvider = (TextFileDocumentProvider)this.mSourcePage.getDocumentProvider()).getDocument((Object)this.mSourcePage.getEditorInput())) != null) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                this.mDescriptionModel.serialize(byteArrayOutputStream);
                iDocument.set(byteArrayOutputStream.toString());
            }
            finally {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDescFromSource() {
        TextFileDocumentProvider textFileDocumentProvider;
        IDocument iDocument;
        if (this.mSourcePage.getDocumentProvider() instanceof TextFileDocumentProvider && (iDocument = (textFileDocumentProvider = (TextFileDocumentProvider)this.mSourcePage.getDocumentProvider()).getDocument((Object)this.mSourcePage.getEditorInput())) != null) {
            try (StringReader stringReader = null;){
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", true);
                sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                DescriptionHandler descriptionHandler = new DescriptionHandler(this.getDescriptionModel());
                stringReader = new StringReader(iDocument.get());
                InputSource inputSource = new InputSource(stringReader);
                this.getDescriptionModel().setSuspendEvent(true);
                sAXParser.parse(inputSource, (DefaultHandler)descriptionHandler);
                this.mFormPage.reloadData();
                this.getDescriptionModel().setSuspendEvent(false);
            }
        }
    }
}

