/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionEditor;
import org.libreoffice.ide.eclipse.core.editors.description.GeneralSection;
import org.libreoffice.ide.eclipse.core.editors.description.IntegrationSection;
import org.libreoffice.ide.eclipse.core.editors.description.LicenseSection;
import org.libreoffice.ide.eclipse.core.editors.description.MirrorsSection;
import org.libreoffice.ide.eclipse.core.editors.description.PublisherSection;
import org.libreoffice.ide.eclipse.core.editors.description.ReleaseNotesSection;
import org.libreoffice.ide.eclipse.core.editors.utils.AbstractSection;
import org.libreoffice.ide.eclipse.core.editors.utils.LocaleSelector;
import org.libreoffice.ide.eclipse.core.editors.utils.LocalizedSection;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;

public class DescriptionFormPage
extends FormPage {
    private LocaleSelector mLocaleSel;
    private DescriptionModel mModel;
    private ArrayList<AbstractSection<DescriptionModel>> mSections = new ArrayList();

    public DescriptionFormPage(FormEditor formEditor, String string) {
        super(formEditor, string, Messages.getString("PackageOverviewFormPage.Title"));
    }

    public void setModel(DescriptionModel descriptionModel) {
        this.mModel = descriptionModel;
        for (AbstractSection<DescriptionModel> abstractSection : this.mSections) {
            abstractSection.setModel(descriptionModel);
        }
    }

    public DescriptionModel getModel() {
        return this.mModel;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText(Messages.getString("PackageOverviewFormPage.Title"));
        Composite composite = scrolledForm.getBody();
        FormToolkit formToolkit = this.getManagedForm().getToolkit();
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        String string = Messages.getString("PackageOverviewFormPage.Description");
        Label label = formToolkit.createLabel(composite, string, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        ArrayList<LocalizedSection<DescriptionModel>> arrayList = this.createMainPage(formToolkit, composite);
        Composite composite2 = formToolkit.createComposite(composite);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout());
        this.mLocaleSel = new LocaleSelector(formToolkit, composite2);
        for (LocalizedSection<DescriptionModel> abstractSection : arrayList) {
            this.mLocaleSel.addListener(abstractSection);
        }
        this.mLocaleSel.loadLocales(this.mModel.getAllLocales());
        for (AbstractSection abstractSection : this.mSections) {
            abstractSection.loadData();
            this.mModel.addListener(abstractSection);
        }
        this.mModel.setSuspendEvent(false);
    }

    private ArrayList<LocalizedSection<DescriptionModel>> createMainPage(FormToolkit formToolkit, Composite composite) {
        ArrayList<LocalizedSection<DescriptionModel>> arrayList = new ArrayList<LocalizedSection<DescriptionModel>>();
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout());
        Composite composite3 = formToolkit.createComposite(composite);
        composite3.setLayoutData((Object)new GridData(1808));
        composite3.setLayout((Layout)new GridLayout());
        IFileEditorInput iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        IProject iProject = iFileEditorInput.getFile().getProject();
        GeneralSection generalSection = new GeneralSection(composite2, this, iProject);
        arrayList.add(generalSection);
        this.mSections.add(generalSection);
        IntegrationSection integrationSection = new IntegrationSection(composite2, this);
        this.mSections.add(integrationSection);
        PublisherSection publisherSection = new PublisherSection(composite2, this);
        arrayList.add(publisherSection);
        this.mSections.add(publisherSection);
        ReleaseNotesSection releaseNotesSection = new ReleaseNotesSection(composite2, this);
        arrayList.add(releaseNotesSection);
        this.mSections.add(releaseNotesSection);
        MirrorsSection mirrorsSection = new MirrorsSection(composite3, this);
        this.mSections.add(mirrorsSection);
        LicenseSection licenseSection = new LicenseSection(composite3, this, iProject);
        this.mSections.add(licenseSection);
        arrayList.add(licenseSection);
        return arrayList;
    }

    public boolean canLeaveThePage() {
        DescriptionEditor descriptionEditor = (DescriptionEditor)this.getEditor();
        descriptionEditor.writeDescrToSource();
        return super.canLeaveThePage();
    }

    public void reloadData() {
        this.getModel().setSuspendEvent(true);
        for (AbstractSection<DescriptionModel> abstractSection : this.mSections) {
            abstractSection.loadData();
        }
        this.getModel().setSuspendEvent(false);
    }
}

