/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionFormPage;
import org.libreoffice.ide.eclipse.core.editors.utils.LocalizedSection;
import org.libreoffice.ide.eclipse.core.gui.ProjectSelectionDialog;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;

public class GeneralSection
extends LocalizedSection<DescriptionModel> {
    private static final int LAYOUT_COLS = 3;
    private IProject mProject;
    private Text mNameTxt;
    private Text mIdTxt;
    private Text mVersionTxt;
    private Text mDescriptionTxt;
    private Button mDescriptionBtn;
    private Text mIconText;
    private Button mIconButton;
    private Text mIconHCText;
    private Button mIconHCButton;

    public GeneralSection(Composite composite, DescriptionFormPage descriptionFormPage, IProject iProject) {
        super(composite, descriptionFormPage, 256);
        this.getSection().setText(Messages.getString("GeneralSection.Title"));
        this.mProject = iProject;
        this.setModel(descriptionFormPage.getModel());
    }

    @Override
    public void loadData() {
        ((DescriptionModel)this.getModel()).setSuspendEvent(true);
        if (!((DescriptionModel)this.getModel()).getDisplayNames().isEmpty()) {
            this.mNameTxt.setText(((DescriptionModel)this.getModel()).getDisplayNames().get(this.mCurrentLocale));
        }
        this.mIdTxt.setText(((DescriptionModel)this.getModel()).getId());
        this.mVersionTxt.setText(((DescriptionModel)this.getModel()).getVersion());
        if (!((DescriptionModel)this.getModel()).getDescriptions().isEmpty()) {
            this.mDescriptionTxt.setText(((DescriptionModel)this.getModel()).getDescriptions().get(this.mCurrentLocale));
        }
        this.mIconText.setText(((DescriptionModel)this.getModel()).getDefaultIcon());
        this.mIconHCText.setText(((DescriptionModel)this.getModel()).getHCIcon());
        ((DescriptionModel)this.getModel()).setSuspendEvent(false);
    }

    @Override
    protected void createControls(FormToolkit formToolkit, Composite composite) {
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = formToolkit.createLabel(composite, Messages.getString("GeneralSection.Description"), 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.createNameControls(formToolkit, composite);
        this.createIdentifierControls(formToolkit, composite);
        this.createVersionControls(formToolkit, composite);
        this.createDescriptionControls(formToolkit, composite);
        this.createIconControls(formToolkit, composite);
    }

    @Override
    public void addLocale(Locale locale) {
        if (!((DescriptionModel)this.getModel()).getDisplayNames().containsKey(locale)) {
            ((DescriptionModel)this.getModel()).addDisplayName(locale, new String());
        }
        if (!((DescriptionModel)this.getModel()).getDescriptions().containsKey(locale)) {
            ((DescriptionModel)this.getModel()).addDescription(locale, new String());
        }
        this.mNameTxt.setEnabled(true);
        this.mDescriptionTxt.setEnabled(true);
        this.mDescriptionBtn.setEnabled(true);
    }

    @Override
    public void deleteLocale(Locale locale) {
        ((DescriptionModel)this.getModel()).removeDisplayName(locale);
        ((DescriptionModel)this.getModel()).removeDescription(locale);
        if (((DescriptionModel)this.getModel()).getDisplayNames().isEmpty()) {
            this.mNameTxt.setEnabled(false);
        }
        if (((DescriptionModel)this.getModel()).getDescriptions().isEmpty()) {
            this.mDescriptionTxt.setEnabled(false);
            this.mDescriptionBtn.setEnabled(false);
        }
    }

    @Override
    public void selectLocale(Locale locale) {
        if (this.mCurrentLocale != null) {
            ((DescriptionModel)this.getModel()).addDisplayName(this.mCurrentLocale, this.mNameTxt.getText());
            ((DescriptionModel)this.getModel()).addDescription(this.mCurrentLocale, this.mDescriptionTxt.getText());
        }
        super.selectLocale(locale);
        String string = ((DescriptionModel)this.getModel()).getDisplayNames().get(locale);
        this.mNameTxt.setText(string);
        this.mDescriptionTxt.setText(((DescriptionModel)this.getModel()).getDescriptions().get(locale));
    }

    private void createNameControls(FormToolkit formToolkit, Composite composite) {
        formToolkit.createLabel(composite, Messages.getString("GeneralSection.Name"));
        this.mNameTxt = formToolkit.createText(composite, new String());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mNameTxt.setLayoutData((Object)gridData);
        this.mNameTxt.setEnabled(false);
        this.mNameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)GeneralSection.this.getModel()).addDisplayName(GeneralSection.this.mCurrentLocale, GeneralSection.this.mNameTxt.getText());
            }
        });
    }

    private void createIdentifierControls(FormToolkit formToolkit, Composite composite) {
        formToolkit.createLabel(composite, Messages.getString("GeneralSection.Identifier"));
        this.mIdTxt = formToolkit.createText(composite, new String());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mIdTxt.setLayoutData((Object)gridData);
        this.mIdTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)GeneralSection.this.getModel()).setId(GeneralSection.this.mIdTxt.getText());
            }
        });
    }

    private void createVersionControls(FormToolkit formToolkit, Composite composite) {
        formToolkit.createLabel(composite, Messages.getString("GeneralSection.Version"));
        this.mVersionTxt = formToolkit.createText(composite, new String());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mVersionTxt.setLayoutData((Object)gridData);
        this.mVersionTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)GeneralSection.this.getModel()).setVersion(GeneralSection.this.mVersionTxt.getText());
            }
        });
    }

    private void createDescriptionControls(FormToolkit formToolkit, Composite composite) {
        formToolkit.createLabel(composite, Messages.getString("GeneralSection.DescriptionFile"));
        this.mDescriptionTxt = formToolkit.createText(composite, new String());
        this.mDescriptionTxt.setLayoutData((Object)new GridData(768));
        this.mDescriptionTxt.setEnabled(false);
        this.mDescriptionTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)GeneralSection.this.getModel()).addDescription(GeneralSection.this.mCurrentLocale, GeneralSection.this.mDescriptionTxt.getText());
            }
        });
        this.mDescriptionBtn = formToolkit.createButton(composite, "...", 8);
        this.mDescriptionBtn.setLayoutData((Object)new GridData(128));
        this.mDescriptionBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IResource iResource;
                ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(GeneralSection.this.mProject, Messages.getString("GeneralSection.FileChooserTooltip"));
                if (projectSelectionDialog.open() == 0 && (iResource = projectSelectionDialog.getSelected()) != null && iResource.getType() == 1) {
                    IFile iFile = (IFile)iResource;
                    String string = iFile.getProjectRelativePath().toString();
                    GeneralSection.this.mDescriptionTxt.setText(string);
                }
            }
        });
    }

    private void createIconControls(FormToolkit formToolkit, Composite composite) {
        formToolkit.createLabel(composite, Messages.getString("GeneralSection.Icon"));
        this.mIconText = formToolkit.createText(composite, new String());
        this.mIconText.setLayoutData((Object)new GridData(768));
        this.mIconText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)GeneralSection.this.getModel()).setDefaultIcon(GeneralSection.this.mIconText.getText());
            }
        });
        this.mIconButton = formToolkit.createButton(composite, "...", 8);
        this.mIconButton.setLayoutData((Object)new GridData(128));
        this.mIconButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IResource iResource;
                ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(GeneralSection.this.mProject, Messages.getString("GeneralSection.FileChooserTooltip"));
                if (projectSelectionDialog.open() == 0 && (iResource = projectSelectionDialog.getSelected()) != null && iResource.getType() == 1) {
                    IFile iFile = (IFile)iResource;
                    String string = iFile.getProjectRelativePath().toString();
                    GeneralSection.this.mIconText.setText(string);
                }
            }
        });
        formToolkit.createLabel(composite, Messages.getString("GeneralSection.HCIcon"));
        this.mIconHCText = formToolkit.createText(composite, new String());
        this.mIconHCText.setLayoutData((Object)new GridData(768));
        this.mIconHCText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)GeneralSection.this.getModel()).setHCIcon(GeneralSection.this.mIconHCText.getText());
            }
        });
        this.mIconHCButton = formToolkit.createButton(composite, "...", 8);
        this.mIconHCButton.setLayoutData((Object)new GridData(128));
        this.mIconHCButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IResource iResource;
                ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(GeneralSection.this.mProject, Messages.getString("GeneralSection.FileChooserTooltip"));
                if (projectSelectionDialog.open() == 0 && (iResource = projectSelectionDialog.getSelected()) != null && iResource.getType() == 1) {
                    IFile iFile = (IFile)iResource;
                    String string = iFile.getProjectRelativePath().toString();
                    GeneralSection.this.mIconHCText.setText(string);
                }
            }
        });
    }
}

