/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionFormPage;
import org.libreoffice.ide.eclipse.core.editors.utils.AbstractSection;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;

public class IntegrationSection
extends AbstractSection<DescriptionModel> {
    static final String SEPARATOR = ",";
    static final String[] PLATFORMS = new String[]{"all", "freebsd_x86", "freebsd_x86_64", "linux_arm_eabi", "linux_arm_oabi", "linux_ia64", "linux_mips_eb", "linux_mips_el", "linux_powerpc", "linux_powerpc64", "linux_s390", "linux_s390x", "linux_sparc", "linux_x86", "linux_x86_64", "macosx_powerpc", "macosx_x86", "os2_x86", "solaris_sparc", "solaris_x86", "windows_x86"};
    private static final int GRID_COLUMS = 3;
    private DescriptionFormPage mPage;
    private Text mMinOOoTxt;
    private Text mMaxOOoTxt;
    private Text mPlatformTxt;

    public IntegrationSection(Composite composite, DescriptionFormPage descriptionFormPage) {
        super(composite, descriptionFormPage, 256);
        this.mPage = descriptionFormPage;
        this.createContent();
        this.setModel(descriptionFormPage.getModel());
    }

    @Override
    public void loadData() {
        ((DescriptionModel)this.getModel()).setSuspendEvent(true);
        this.mMinOOoTxt.setText(((DescriptionModel)this.getModel()).getMinOOo());
        this.mMaxOOoTxt.setText(((DescriptionModel)this.getModel()).getMaxOOo());
        this.mPlatformTxt.setText(((DescriptionModel)this.getModel()).getPlatforms());
        ((DescriptionModel)this.getModel()).setSuspendEvent(false);
    }

    private void createContent() {
        Section section = this.getSection();
        section.setText(Messages.getString("IntegrationSection.Title"));
        section.setLayoutData((Object)new GridData(768));
        FormToolkit formToolkit = this.mPage.getManagedForm().getToolkit();
        Composite composite = formToolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(3, false));
        String string = Messages.getString("IntegrationSection.Description");
        Label label = formToolkit.createLabel(composite, string, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite, Messages.getString("IntegrationSection.MinOOoVersion"));
        this.mMinOOoTxt = formToolkit.createText(composite, new String());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mMinOOoTxt.setLayoutData((Object)gridData);
        this.mMinOOoTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)IntegrationSection.this.getModel()).setMinOOo(IntegrationSection.this.mMinOOoTxt.getText());
                IntegrationSection.this.markDirty();
            }
        });
        formToolkit.createLabel(composite, Messages.getString("IntegrationSection.MaxOOoVersion"));
        this.mMaxOOoTxt = formToolkit.createText(composite, new String());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mMaxOOoTxt.setLayoutData((Object)gridData);
        this.mMaxOOoTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)IntegrationSection.this.getModel()).setMaxOOo(IntegrationSection.this.mMaxOOoTxt.getText());
                IntegrationSection.this.markDirty();
            }
        });
        formToolkit.createLabel(composite, Messages.getString("IntegrationSection.Platforms"));
        this.mPlatformTxt = formToolkit.createText(composite, "all");
        this.mPlatformTxt.setLayoutData((Object)new GridData(768));
        this.mPlatformTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)IntegrationSection.this.getModel()).setPlatforms(IntegrationSection.this.mPlatformTxt.getText());
                IntegrationSection.this.markDirty();
            }
        });
        Button button = formToolkit.createButton(composite, "...", 0x800008);
        button.setLayoutData((Object)new GridData(128));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PlatformDialog platformDialog = new PlatformDialog();
                if (platformDialog.open() == 0) {
                    IntegrationSection.this.mPlatformTxt.setText(platformDialog.getSelected());
                }
            }
        });
        formToolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private class PlatformDialog
    extends Dialog {
        private CheckboxTableViewer mList;
        private ArrayList<String> mSelected;

        public PlatformDialog() {
            super(new Shell(Display.getDefault()));
            this.setShellStyle(65552);
            String string = IntegrationSection.this.mPlatformTxt.getText().replace(" ", new String());
            String[] stringArray = string.split(IntegrationSection.SEPARATOR);
            this.mSelected = new ArrayList<String>(Arrays.asList(stringArray));
        }

        public String getSelected() {
            String string = new String();
            for (String string2 : this.mSelected) {
                string = string + string2 + IntegrationSection.SEPARATOR;
            }
            return string.substring(0, string.length() - IntegrationSection.SEPARATOR.length());
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            composite2.setLayout((Layout)new GridLayout());
            composite2.setLayoutData((Object)new GridData(1808));
            Table table = new Table(composite2, 34);
            this.mList = new CheckboxTableViewer(table);
            this.mList.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.mList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.mList.setInput((Object)PLATFORMS);
            this.mList.setCheckedElements(this.mSelected.toArray());
            this.mList.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                    Object[] objectArray = PlatformDialog.this.mList.getCheckedElements();
                    PlatformDialog.this.mSelected.clear();
                    for (Object object : objectArray) {
                        PlatformDialog.this.mSelected.add(object.toString());
                    }
                }
            });
            return composite2;
        }
    }
}

