/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionFormPage;
import org.libreoffice.ide.eclipse.core.editors.utils.LocalizedSection;
import org.libreoffice.ide.eclipse.core.gui.ProjectSelectionDialog;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;

public class LicenseSection
extends LocalizedSection<DescriptionModel> {
    private static final int LAYOUT_COLS = 3;
    private Text mFileTxt;
    private Button mFileBrowseBtn;
    private Button mUserAcceptBtn;
    private Button mSuppressUpdateBtn;
    private IProject mProject;

    public LicenseSection(Composite composite, DescriptionFormPage descriptionFormPage, IProject iProject) {
        super(composite, descriptionFormPage, 256);
        this.mProject = iProject;
        this.setModel(descriptionFormPage.getModel());
    }

    @Override
    public void loadData() {
        ((DescriptionModel)this.getModel()).setSuspendEvent(true);
        if (!((DescriptionModel)this.getModel()).getLicenses().isEmpty()) {
            this.mFileTxt.setText(((DescriptionModel)this.getModel()).getLicenses().get(this.mCurrentLocale));
        }
        this.mSuppressUpdateBtn.setSelection(((DescriptionModel)this.getModel()).isSuppressOnUpdate());
        this.mUserAcceptBtn.setSelection(((DescriptionModel)this.getModel()).isAcceptByUser());
        ((DescriptionModel)this.getModel()).setSuspendEvent(false);
    }

    @Override
    protected void createControls(FormToolkit formToolkit, Composite composite) {
        Section section = this.getSection();
        section.setLayoutData((Object)new GridData(1808));
        section.setText(Messages.getString("LicenseSection.Title"));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = formToolkit.createLabel(composite, Messages.getString("LicenseSection.Description"), 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.createFileControls(formToolkit, composite);
        this.mUserAcceptBtn = formToolkit.createButton(composite, Messages.getString("LicenseSection.UserAccept"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.mUserAcceptBtn.setLayoutData((Object)gridData);
        this.mUserAcceptBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ((DescriptionModel)LicenseSection.this.getModel()).setAcceptByUser(LicenseSection.this.mUserAcceptBtn.getSelection());
                LicenseSection.this.markDirty();
            }
        });
        String string = Messages.getString("LicenseSection.SuppressUpdate");
        this.mSuppressUpdateBtn = formToolkit.createButton(composite, string, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.mSuppressUpdateBtn.setLayoutData((Object)gridData);
        this.mSuppressUpdateBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ((DescriptionModel)LicenseSection.this.getModel()).setSuppressOnUpdate(LicenseSection.this.mSuppressUpdateBtn.getSelection());
                LicenseSection.this.markDirty();
            }
        });
    }

    private void createFileControls(FormToolkit formToolkit, Composite composite) {
        Label label = formToolkit.createLabel(composite, Messages.getString("LicenseSection.LicenseFile"));
        label.setLayoutData((Object)new GridData(32));
        this.mFileTxt = formToolkit.createText(composite, new String());
        this.mFileTxt.setLayoutData((Object)new GridData(768));
        this.mFileTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)LicenseSection.this.getModel()).addLicense(LicenseSection.this.mCurrentLocale, LicenseSection.this.mFileTxt.getText());
                LicenseSection.this.markDirty();
            }
        });
        this.mFileBrowseBtn = formToolkit.createButton(composite, "...", 8);
        this.mFileBrowseBtn.setLayoutData((Object)new GridData(128));
        this.mFileBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IResource iResource;
                ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(LicenseSection.this.mProject, Messages.getString("LicenseSection.FileChooserTooltip"));
                if (projectSelectionDialog.open() == 0 && (iResource = projectSelectionDialog.getSelected()) != null && iResource.getType() == 1) {
                    IFile iFile = (IFile)iResource;
                    String string = iFile.getProjectRelativePath().toString();
                    LicenseSection.this.mFileTxt.setText(string);
                }
            }
        });
    }

    @Override
    public void addLocale(Locale locale) {
        ((DescriptionModel)this.getModel()).addLicense(locale, new String());
        this.mFileBrowseBtn.setEnabled(true);
        this.mFileTxt.setEnabled(true);
    }

    @Override
    public void deleteLocale(Locale locale) {
        ((DescriptionModel)this.getModel()).removeLicense(locale);
        if (((DescriptionModel)this.getModel()).getLicenses().isEmpty()) {
            this.mFileBrowseBtn.setEnabled(false);
            this.mFileTxt.setEnabled(false);
        }
    }

    @Override
    public void selectLocale(Locale locale) {
        if (this.mCurrentLocale != null) {
            ((DescriptionModel)this.getModel()).addLicense(this.mCurrentLocale, this.mFileTxt.getText());
        }
        super.selectLocale(locale);
        String string = ((DescriptionModel)this.getModel()).getLicenses().get(locale);
        this.mFileTxt.setText(string);
    }
}

