/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionFormPage;
import org.libreoffice.ide.eclipse.core.editors.utils.AbstractSection;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;

public class MirrorsSection
extends AbstractSection<DescriptionModel> {
    private static final int COLUMN_WIDTH = 200;
    private DescriptionFormPage mPage;
    private TableViewer mTable;
    private Text mUrlTxt;
    private Button mAddBtn;
    private MenuItem mDeleteAction;

    public MirrorsSection(Composite composite, DescriptionFormPage descriptionFormPage) {
        super(composite, descriptionFormPage, 256);
        this.mPage = descriptionFormPage;
        this.createContent();
        this.setModel(descriptionFormPage.getModel());
    }

    @Override
    public void loadData() {
        ((DescriptionModel)this.getModel()).setSuspendEvent(true);
        this.mTable.setInput(((DescriptionModel)this.getModel()).getUpdateInfos());
        ((DescriptionModel)this.getModel()).setSuspendEvent(false);
    }

    private void createContent() {
        Section section = this.getSection();
        section.setText("Update mirrors");
        section.setLayoutData((Object)new GridData(1808));
        FormToolkit formToolkit = this.mPage.getManagedForm().getToolkit();
        Composite composite = formToolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = formToolkit.createLabel(composite, Messages.getString("MirrorsSection.Description"), 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.createTable(composite);
        String string = Messages.getString("MirrorsSection.MirrorTextTitle");
        Label label2 = formToolkit.createLabel(composite, string);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        this.mUrlTxt = formToolkit.createText(composite, new String());
        this.mUrlTxt.setLayoutData((Object)new GridData(768));
        this.mUrlTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MirrorsSection.this.mAddBtn.setEnabled(0 != MirrorsSection.this.mUrlTxt.getText().trim().length());
            }
        });
        this.mAddBtn = formToolkit.createButton(composite, Messages.getString("MirrorsSection.Add"), 8);
        this.mAddBtn.setLayoutData((Object)new GridData(128));
        this.mAddBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = MirrorsSection.this.mUrlTxt.getText();
                ((DescriptionModel)MirrorsSection.this.getModel()).addUpdateInfo(string);
                MirrorsSection.this.mTable.add((Object)string);
                MirrorsSection.this.mUrlTxt.setText(new String());
                MirrorsSection.this.markDirty();
            }
        });
        formToolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private void createTable(Composite composite) {
        Table table = new Table(composite, 65540);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        this.mTable = new TableViewer(table);
        this.mTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mTable.setLabelProvider((IBaseLabelProvider)new UrlLabelProvider());
        this.mTable.setColumnProperties(new String[]{"url"});
        this.mTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table)});
        this.mTable.setCellModifier((ICellModifier)new UrlCellModifier());
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setMoveable(false);
        tableColumn.setWidth(200);
        Menu menu = new Menu((Control)table);
        this.mDeleteAction = new MenuItem(menu, 8);
        this.mDeleteAction.setText(Messages.getString("MirrorsSection.Remove"));
        this.mDeleteAction.setImage(OOEclipsePlugin.getImage("DELETE"));
        this.mDeleteAction.setEnabled(false);
        this.mDeleteAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MirrorsSection.this.mTable.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                MirrorsSection.this.mTable.remove(object);
                ((DescriptionModel)MirrorsSection.this.getModel()).removeUpdateInfo(object.toString());
                MirrorsSection.this.markDirty();
            }
        });
        this.mTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                MirrorsSection.this.mDeleteAction.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
        table.setMenu(menu);
    }

    private class UrlLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private UrlLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return object.toString();
        }
    }

    private class UrlCellModifier
    implements ICellModifier {
        private UrlCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            return object;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                String string2 = object3.toString();
                int n = ((DescriptionModel)MirrorsSection.this.getModel()).getUpdateInfos().indexOf(string2);
                ((DescriptionModel)MirrorsSection.this.getModel()).replaceUpdateInfo(n, object2.toString());
                MirrorsSection.this.mTable.replace(object2, n);
                MirrorsSection.this.mTable.refresh(object3);
                MirrorsSection.this.markDirty();
            }
        }
    }
}

