/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import java.util.Locale;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionFormPage;
import org.libreoffice.ide.eclipse.core.editors.utils.LocalizedSection;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;
import org.libreoffice.ide.eclipse.core.model.description.PublisherInfos;

public class PublisherSection
extends LocalizedSection<DescriptionModel> {
    private static final int LAYOUT_COLS = 2;
    private Text mUrlTxt;
    private Text mNameTxt;

    public PublisherSection(Composite composite, DescriptionFormPage descriptionFormPage) {
        super(composite, descriptionFormPage, 256);
        this.getSection().setText(Messages.getString("PublisherSection.Title"));
        this.setModel(descriptionFormPage.getModel());
    }

    @Override
    public void loadData() {
        ((DescriptionModel)this.getModel()).setSuspendEvent(true);
        if (!((DescriptionModel)this.getModel()).getPublisherInfos().isEmpty()) {
            PublisherInfos publisherInfos = ((DescriptionModel)this.getModel()).getPublisherInfos().get(this.mCurrentLocale);
            this.mUrlTxt.setText(publisherInfos.getUrl());
            this.mNameTxt.setText(publisherInfos.getName());
        }
        ((DescriptionModel)this.getModel()).setSuspendEvent(false);
    }

    @Override
    protected void createControls(FormToolkit formToolkit, Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = formToolkit.createLabel(composite, Messages.getString("PublisherSection.Description"), 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite, Messages.getString("PublisherSection.Name"));
        this.mNameTxt = formToolkit.createText(composite, "");
        this.mNameTxt.setLayoutData((Object)new GridData(768));
        this.mNameTxt.setEnabled(false);
        this.mNameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PublisherInfos publisherInfos = ((DescriptionModel)PublisherSection.this.getModel()).getPublisherInfos().get(PublisherSection.this.mCurrentLocale);
                publisherInfos.setName(PublisherSection.this.mNameTxt.getText());
                PublisherSection.this.markDirty();
            }
        });
        formToolkit.createLabel(composite, Messages.getString("PublisherSection.Url"));
        this.mUrlTxt = formToolkit.createText(composite, "");
        this.mUrlTxt.setLayoutData((Object)new GridData(768));
        this.mUrlTxt.setEnabled(false);
        this.mUrlTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PublisherInfos publisherInfos = ((DescriptionModel)PublisherSection.this.getModel()).getPublisherInfos().get(PublisherSection.this.mCurrentLocale);
                publisherInfos.setUrl(PublisherSection.this.mUrlTxt.getText());
                PublisherSection.this.markDirty();
            }
        });
    }

    @Override
    public void addLocale(Locale locale) {
        if (!((DescriptionModel)this.getModel()).getPublisherInfos().containsKey(locale)) {
            ((DescriptionModel)this.getModel()).addPublisherInfo(locale, new PublisherInfos());
        }
        this.mNameTxt.setEnabled(true);
        this.mUrlTxt.setEnabled(true);
    }

    @Override
    public void deleteLocale(Locale locale) {
        ((DescriptionModel)this.getModel()).removePublisherInfo(locale);
        if (((DescriptionModel)this.getModel()).getPublisherInfos().isEmpty()) {
            this.mNameTxt.setEnabled(false);
            this.mUrlTxt.setEnabled(false);
        }
    }

    @Override
    public void selectLocale(Locale locale) {
        PublisherInfos publisherInfos;
        if (this.mCurrentLocale != null) {
            publisherInfos = ((DescriptionModel)this.getModel()).getPublisherInfos().get(this.mCurrentLocale);
            publisherInfos.setName(this.mNameTxt.getText());
            publisherInfos.setUrl(this.mUrlTxt.getText());
        }
        super.selectLocale(locale);
        publisherInfos = ((DescriptionModel)this.getModel()).getPublisherInfos().get(locale);
        this.mNameTxt.setText(publisherInfos.getName());
        this.mUrlTxt.setText(publisherInfos.getUrl());
    }
}

