/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.description;

import java.util.Locale;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.description.DescriptionFormPage;
import org.libreoffice.ide.eclipse.core.editors.utils.ILocaleListener;
import org.libreoffice.ide.eclipse.core.editors.utils.LocalizedSection;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;

public class ReleaseNotesSection
extends LocalizedSection<DescriptionModel>
implements ILocaleListener {
    private static final int LAYOUT_COLS = 2;
    private Text mUrlTxt;

    public ReleaseNotesSection(Composite composite, DescriptionFormPage descriptionFormPage) {
        super(composite, descriptionFormPage, 256);
        this.getSection().setText(Messages.getString("ReleaseNotesSection.Title"));
        this.setModel(descriptionFormPage.getModel());
    }

    @Override
    public void loadData() {
        ((DescriptionModel)this.getModel()).setSuspendEvent(true);
        if (!((DescriptionModel)this.getModel()).getReleaseNotes().isEmpty()) {
            this.mUrlTxt.setText(((DescriptionModel)this.getModel()).getReleaseNotes().get(this.mCurrentLocale));
        }
        ((DescriptionModel)this.getModel()).setSuspendEvent(false);
    }

    @Override
    protected void createControls(FormToolkit formToolkit, Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, false));
        String string = Messages.getString("ReleaseNotesSection.Description");
        Label label = formToolkit.createLabel(composite, string, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite, Messages.getString("ReleaseNotesSection.Url"));
        this.mUrlTxt = formToolkit.createText(composite, new String());
        this.mUrlTxt.setLayoutData((Object)new GridData(768));
        this.mUrlTxt.setEnabled(false);
        this.mUrlTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((DescriptionModel)ReleaseNotesSection.this.getModel()).addReleaseNote(ReleaseNotesSection.this.mCurrentLocale, ReleaseNotesSection.this.mUrlTxt.getText());
                ReleaseNotesSection.this.markDirty();
            }
        });
    }

    @Override
    public void addLocale(Locale locale) {
        if (!((DescriptionModel)this.getModel()).getReleaseNotes().containsKey(locale)) {
            ((DescriptionModel)this.getModel()).addReleaseNote(locale, new String());
        }
        this.mUrlTxt.setEnabled(true);
    }

    @Override
    public void deleteLocale(Locale locale) {
        ((DescriptionModel)this.getModel()).removeReleaseNote(locale);
        if (((DescriptionModel)this.getModel()).getReleaseNotes().isEmpty()) {
            this.mUrlTxt.setEnabled(false);
        }
    }

    @Override
    public void selectLocale(Locale locale) {
        if (this.mCurrentLocale != null) {
            ((DescriptionModel)this.getModel()).addReleaseNote(this.mCurrentLocale, this.mUrlTxt.getText());
        }
        super.selectLocale(locale);
        this.mUrlTxt.setText(((DescriptionModel)this.getModel()).getReleaseNotes().get(locale));
    }
}

