/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.idl;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.libreoffice.ide.eclipse.core.editors.idl.UnoidlDoubleClickStrategy;
import org.libreoffice.ide.eclipse.core.editors.syntax.NonRuleBasedDamagerRepairer;
import org.libreoffice.ide.eclipse.core.editors.syntax.UnoidlDocScanner;
import org.libreoffice.ide.eclipse.core.editors.syntax.UnoidlPreprocessorScanner;
import org.libreoffice.ide.eclipse.core.editors.syntax.UnoidlScanner;
import org.libreoffice.ide.eclipse.core.editors.utils.ColorProvider;

public class UnoidlConfiguration
extends SourceViewerConfiguration {
    private UnoidlDoubleClickStrategy mDoubleClickStrategy;
    private UnoidlScanner mScanner;
    private UnoidlDocScanner mDocScanner;
    private UnoidlPreprocessorScanner mPreprocScanner;
    private ColorProvider mColorManager;

    public UnoidlConfiguration(ColorProvider colorProvider) {
        this.mColorManager = colorProvider;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.mDoubleClickStrategy == null) {
            this.mDoubleClickStrategy = new UnoidlDoubleClickStrategy();
        }
        return this.mDoubleClickStrategy;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new DefaultAnnotationHover(false);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer iSourceViewer) {
        return new DefaultAnnotationHover(true);
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"_idl_autocomment", "_idl_comment", "_idl_preprocessor"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getDocScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "_idl_autocomment");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "_idl_autocomment");
        NonRuleBasedDamagerRepairer nonRuleBasedDamagerRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.mColorManager.getColor("commentColor")));
        presentationReconciler.setDamager((IPresentationDamager)nonRuleBasedDamagerRepairer, "_idl_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)nonRuleBasedDamagerRepairer, "_idl_comment");
        DefaultDamagerRepairer defaultDamagerRepairer2 = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer2, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer2, "__dftl_partition_content_type");
        DefaultDamagerRepairer defaultDamagerRepairer3 = new DefaultDamagerRepairer((ITokenScanner)this.getPreprocScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer3, "_idl_preprocessor");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer3, "_idl_preprocessor");
        return presentationReconciler;
    }

    protected UnoidlScanner getCodeScanner() {
        if (this.mScanner == null) {
            this.mScanner = new UnoidlScanner(this.mColorManager);
            this.mScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.mColorManager.getColor("textColor"))));
        }
        return this.mScanner;
    }

    protected UnoidlDocScanner getDocScanner() {
        if (this.mDocScanner == null) {
            this.mDocScanner = new UnoidlDocScanner(this.mColorManager);
            this.mDocScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.mColorManager.getColor("docCommentColor"))));
        }
        return this.mDocScanner;
    }

    protected UnoidlPreprocessorScanner getPreprocScanner() {
        if (this.mPreprocScanner == null) {
            this.mPreprocScanner = new UnoidlPreprocessorScanner(this.mColorManager);
            this.mPreprocScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.mColorManager.getColor("preprocessorColor"))));
        }
        return this.mPreprocScanner;
    }
}

