/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.pack;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.pack.PackageFormPage;
import org.libreoffice.ide.eclipse.core.editors.pack.PackagePropertiesEditor;
import org.libreoffice.ide.eclipse.core.model.pack.PackagePropertiesModel;
import org.libreoffice.ide.eclipse.core.model.utils.IModelTreeListener;

public class ContentsSection
extends SectionPart {
    private PackageFormPage mPage;
    private ContainerCheckedTreeViewer mTreeViewer;
    private ViewerFilter mTreeFilter;
    private ICheckStateListener mCheckListener;
    private IModelTreeListener mTreeListener;

    public ContentsSection(PackageFormPage packageFormPage) {
        super(packageFormPage.getManagedForm().getForm().getBody(), packageFormPage.getManagedForm().getToolkit(), 256);
        this.mPage = packageFormPage;
        PackagePropertiesModel packagePropertiesModel = this.getModel();
        Section section = this.getSection();
        section.setText(Messages.getString("ContentsSection.Title"));
        section.setLayoutData((Object)new GridData(1808));
        this.mTreeViewer = new ContainerCheckedTreeViewer((Composite)section);
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        this.mTreeViewer.setContentProvider((IContentProvider)workbenchContentProvider);
        this.mTreeViewer.setComparator(new ViewerComparator(String.CASE_INSENSITIVE_ORDER));
        this.addTreeListener(packagePropertiesModel);
        this.addCheckStateListener(packagePropertiesModel);
        this.addFilter(packagePropertiesModel);
        this.setCheckStateProvider(packagePropertiesModel);
        section.setClient(this.mTreeViewer.getControl());
    }

    public void setContents() {
        if (this.mTreeViewer != null) {
            this.mTreeViewer.setInput((Object)this.mPage.getProject());
            this.mTreeViewer.expandAll();
            this.mTreeViewer.collapseAll();
        }
    }

    public void dispose() {
        this.mTreeViewer.removeFilter(this.mTreeFilter);
        this.mTreeViewer.removeCheckStateListener(this.mCheckListener);
        this.getModel().removeTreeListener(this.mTreeListener);
        super.dispose();
    }

    private PackagePropertiesModel getModel() {
        return ((PackagePropertiesEditor)this.mPage.getEditor()).getModel();
    }

    private void addTreeListener(PackagePropertiesModel packagePropertiesModel) {
        IModelTreeListener iModelTreeListener = new IModelTreeListener(){

            @Override
            public void modelRefreshed() {
                if (ContentsSection.this.mTreeViewer != null) {
                    ContentsSection.this.mTreeViewer.refresh();
                }
            }
        };
        packagePropertiesModel.addTreeListener(iModelTreeListener);
        this.mTreeListener = iModelTreeListener;
    }

    private void addCheckStateListener(final PackagePropertiesModel packagePropertiesModel) {
        ICheckStateListener iCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getElement() instanceof IAdaptable) {
                    IResource iResource = (IResource)((IAdaptable)checkStateChangedEvent.getElement()).getAdapter(IResource.class);
                    if (checkStateChangedEvent.getChecked()) {
                        packagePropertiesModel.addResource(iResource);
                    } else {
                        packagePropertiesModel.removeResource(iResource);
                    }
                }
            }
        };
        this.mTreeViewer.addCheckStateListener(iCheckStateListener);
        this.mCheckListener = iCheckStateListener;
    }

    private void addFilter(final PackagePropertiesModel packagePropertiesModel) {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                IResource iResource;
                boolean bl = true;
                if (object2 instanceof IAdaptable && (iResource = (IResource)((IAdaptable)object2).getAdapter(IResource.class)) != null) {
                    bl = !packagePropertiesModel.isFilteredResource(iResource);
                }
                return bl;
            }
        };
        this.mTreeViewer.addFilter(viewerFilter);
        this.mTreeFilter = viewerFilter;
    }

    private void setCheckStateProvider(final PackagePropertiesModel packagePropertiesModel) {
        this.mTreeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object object) {
                boolean bl = false;
                if (object instanceof IAdaptable) {
                    IResource iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                    bl = packagePropertiesModel.isChecked(iResource);
                }
                return bl;
            }

            public boolean isGrayed(Object object) {
                boolean bl = false;
                if (object instanceof IAdaptable) {
                    IResource iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                    bl = packagePropertiesModel.isGrayed(iResource);
                }
                return bl;
            }
        });
    }
}

