/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.pack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.pack.PackageFormPage;
import org.libreoffice.ide.eclipse.core.editors.pack.PackagePropertiesEditor;
import org.libreoffice.ide.eclipse.core.gui.ProjectSelectionDialog;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;
import org.libreoffice.ide.eclipse.core.model.pack.PackagePropertiesModel;

public class LibsSection
extends SectionPart {
    private static final String P_LIBTYPE = "__p_libtype";
    private static final String P_NAME = "__p_name";
    private static final Integer BASIC_LIB = 0;
    private static final Integer DIALOG_LIB = 1;
    private static final int FOLDER_COLUMN_WIDTH = 200;
    private static final int TYPE_COLUMN_WIDTH = 100;
    private PackageFormPage mPage;
    private TableViewer mTableViewer;
    private Map<Object, Integer> mLibs = new HashMap<Object, Integer>();

    public LibsSection(PackageFormPage packageFormPage) {
        super(packageFormPage.getManagedForm().getForm().getBody(), packageFormPage.getManagedForm().getToolkit(), 256);
        this.mPage = packageFormPage;
        Section section = this.getSection();
        section.setText(Messages.getString("LibsSection.Title"));
        section.setLayoutData((Object)new GridData(1808));
        Composite composite = this.mPage.getManagedForm().getToolkit().createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout());
        this.createTable(composite);
        this.createButtons(composite);
        this.mTableViewer.setInput((Object)this);
        section.setClient((Control)composite);
    }

    public List<IFolder> getBasicLibraries() {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        for (Map.Entry<Object, Integer> entry : this.mLibs.entrySet()) {
            IFolder iFolder = (IFolder)entry.getKey();
            if (!entry.getValue().equals(BASIC_LIB)) continue;
            arrayList.add(iFolder);
        }
        return arrayList;
    }

    public List<IFolder> getDialogLibraries() {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        for (Map.Entry<Object, Integer> entry : this.mLibs.entrySet()) {
            IFolder iFolder = (IFolder)entry.getKey();
            if (!entry.getValue().equals(DIALOG_LIB)) continue;
            arrayList.add(iFolder);
        }
        return arrayList;
    }

    public void setLibraries(PackagePropertiesModel packagePropertiesModel) {
        List<IFolder> list = packagePropertiesModel.getBasicLibraries();
        List<IFolder> list2 = packagePropertiesModel.getDialogLibraries();
        this.mLibs.clear();
        if (this.mPage.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)this.mPage.getEditorInput();
            IProject iProject = iFileEditorInput.getFile().getProject();
            for (IFolder iFolder : list) {
                if (!iFolder.getProject().equals((Object)iProject) || !iFolder.exists()) continue;
                this.mLibs.put(iFolder, BASIC_LIB);
            }
            for (IFolder iFolder : list2) {
                if (!iFolder.getProject().equals((Object)iProject) || !iFolder.exists()) continue;
                this.mLibs.put(iFolder, DIALOG_LIB);
            }
            if (this.mTableViewer != null) {
                this.mTableViewer.refresh();
            }
        }
    }

    private void createTable(Composite composite) {
        Table table = new Table(composite, 67588);
        table.setLayoutData((Object)new GridData(1808));
        this.mTableViewer = new TableViewer(table);
        this.mTableViewer.setContentProvider((IContentProvider)new LibsContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new LibsLabelProvider());
        this.mTableViewer.setCellEditors(new CellEditor[]{null, new ComboBoxCellEditor((Composite)this.mTableViewer.getTable(), new String[]{Messages.getString("LibsSection.BasicLibrary"), Messages.getString("LibsSection.DialogLibrary")})});
        this.mTableViewer.setCellModifier((ICellModifier)new LibsCellModifier());
        this.mTableViewer.setColumnProperties(new String[]{P_NAME, P_LIBTYPE});
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setWidth(200);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setMoveable(false);
        tableColumn2.setResizable(true);
        tableColumn2.setWidth(100);
    }

    private void createButtons(Composite composite) {
        Composite composite2 = this.mPage.getManagedForm().getToolkit().createComposite(composite);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout(2, true));
        Button button = this.mPage.getManagedForm().getToolkit().createButton(composite2, Messages.getString("LibsSection.AddButton"), 8);
        button.setLayoutData((Object)new GridData(640));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IProject iProject = LibsSection.this.mPage.getProject();
                PackagePropertiesEditor packagePropertiesEditor = (PackagePropertiesEditor)LibsSection.this.mPage.getEditor();
                ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(iProject, Messages.getString("LibsSection.AddDescription"));
                projectSelectionDialog.setShowOnlyFolders(true);
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                arrayList.add((IResource)iProject.getFolder("build"));
                arrayList.add((IResource)iProject.getFolder("bin"));
                arrayList.addAll(packagePropertiesEditor.getModel().getBasicLibraries());
                arrayList.addAll(packagePropertiesEditor.getModel().getDialogLibraries());
                arrayList.addAll(packagePropertiesEditor.getModel().getContents());
                arrayList.addAll(UnoidlProjectHelper.getContainedFile(iProject));
                projectSelectionDialog.setFilteredElements(arrayList);
                if (0 == projectSelectionDialog.open()) {
                    IResource iResource = projectSelectionDialog.getSelected();
                    LibsSection.this.mLibs.put(iResource, BASIC_LIB);
                    LibsSection.this.mTableViewer.add((Object)iResource);
                    LibsSection.this.mTableViewer.refresh();
                    LibsSection.this.fireSectionModified();
                }
            }
        });
        Button button2 = this.mPage.getManagedForm().getToolkit().createButton(composite2, Messages.getString("LibsSection.DelButton"), 8);
        button2.setLayoutData((Object)new GridData(544));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISelection iSelection = LibsSection.this.mTableViewer.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    for (Object e : iStructuredSelection) {
                        LibsSection.this.mLibs.remove(e);
                        LibsSection.this.mTableViewer.remove(e);
                    }
                    LibsSection.this.fireSectionModified();
                    LibsSection.this.mTableViewer.refresh();
                }
            }
        });
    }

    private void fireSectionModified() {
        PackagePropertiesEditor packagePropertiesEditor = (PackagePropertiesEditor)this.mPage.getEditor();
        List<IFolder> list = this.getDialogLibraries();
        packagePropertiesEditor.getModel().clearDialogLibraries();
        for (IFolder object2 : list) {
            packagePropertiesEditor.getModel().addDialogLibrary(object2);
        }
        List<IFolder> list2 = this.getBasicLibraries();
        packagePropertiesEditor.getModel().clearBasicLibraries();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            IFolder iFolder = (IFolder)iterator.next();
            packagePropertiesEditor.getModel().addBasicLibrary(iFolder);
        }
    }

    private class LibsContentProvider
    implements IStructuredContentProvider {
        private LibsContentProvider() {
        }

        public Object[] getElements(Object object) {
            return LibsSection.this.mLibs.keySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class LibsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LibsLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            Image image = null;
            if (n == 0 && object instanceof IFolder) {
                IFolder iFolder = (IFolder)object;
                IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)iFolder.getAdapter(IWorkbenchAdapter.class);
                image = iWorkbenchAdapter.getImageDescriptor(object).createImage();
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            if (n == 0 && object instanceof IFolder) {
                string = ((IFolder)object).getProjectRelativePath().toOSString();
            } else if (n == 1) {
                string = ((Integer)LibsSection.this.mLibs.get(object)).equals(BASIC_LIB) ? Messages.getString("LibsSection.BasicLibrary") : Messages.getString("LibsSection.DialogLibrary");
            }
            return string;
        }
    }

    private class LibsCellModifier
    implements ICellModifier {
        private LibsCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return string.equals(LibsSection.P_LIBTYPE);
        }

        public Object getValue(Object object, String string) {
            Object var3_3 = null;
            if (string.equals(LibsSection.P_LIBTYPE)) {
                var3_3 = LibsSection.this.mLibs.get(object);
            }
            return var3_3;
        }

        public void modify(Object object, String string, Object object2) {
            if (string.equals(LibsSection.P_LIBTYPE) && object2 instanceof Integer && object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                LibsSection.this.mLibs.put(object3, (Integer)object2);
                LibsSection.this.mTableViewer.refresh(object3);
                LibsSection.this.fireSectionModified();
            }
        }
    }
}

