/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.pack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.pack.PackageFormPage;
import org.libreoffice.ide.eclipse.core.editors.pack.PackagePropertiesEditor;
import org.libreoffice.ide.eclipse.core.gui.LocaleCellProvider;
import org.libreoffice.ide.eclipse.core.gui.ProjectSelectionDialog;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;

public class PackageDescriptionSection
extends SectionPart {
    private static final String P_NAME = "__p_name";
    private static final String P_LOCALE = "__p_locale";
    private static final int NAME_WIDTH = 250;
    private static final int LOCALE_WIDTH = 250;
    private PackageFormPage mPage;
    private TableViewer mTableViewer;
    private Map<IFile, Locale> mDescriptions = new HashMap<IFile, Locale>();

    public PackageDescriptionSection(PackageFormPage packageFormPage) {
        super(packageFormPage.getManagedForm().getForm().getBody(), packageFormPage.getManagedForm().getToolkit(), 256);
        this.mPage = packageFormPage;
        Section section = this.getSection();
        section.setText(Messages.getString("PackageDescriptionSection.Title"));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        section.setLayoutData((Object)gridData);
        Composite composite = this.mPage.getManagedForm().getToolkit().createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(2, false));
        Table table = new Table(composite, 67588);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setMoveable(false);
        tableColumn.setResizable(false);
        tableColumn.setWidth(250);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setMoveable(false);
        tableColumn2.setResizable(false);
        tableColumn2.setWidth(250);
        this.mTableViewer = new TableViewer(table);
        this.mTableViewer.setColumnProperties(new String[]{P_NAME, P_LOCALE});
        this.mTableViewer.setCellEditors(new CellEditor[]{null, new LocaleCellProvider((Composite)table)});
        this.mTableViewer.setContentProvider((IContentProvider)new DescrContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new DescrLabelProvider());
        this.mTableViewer.setCellModifier((ICellModifier)new DescrCellModifier());
        this.createButtons(composite);
        this.mTableViewer.setInput((Object)this);
        section.setClient((Control)composite);
    }

    public Map<Locale, IFile> getDescriptions() {
        HashMap<Locale, IFile> hashMap = new HashMap<Locale, IFile>();
        for (Map.Entry<IFile, Locale> entry : this.mDescriptions.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public void setDescriptions(Map<Locale, IFile> map) {
        this.mDescriptions.clear();
        for (Map.Entry<Locale, IFile> entry : map.entrySet()) {
            this.mDescriptions.put(entry.getValue(), entry.getKey());
        }
        this.mTableViewer.refresh();
    }

    private void fireSectionModified() {
        PackagePropertiesEditor packagePropertiesEditor = (PackagePropertiesEditor)this.mPage.getEditor();
        Map<Locale, IFile> map = this.getDescriptions();
        packagePropertiesEditor.getModel().clearDescriptions();
        for (Map.Entry<Locale, IFile> entry : map.entrySet()) {
            packagePropertiesEditor.getModel().addDescriptionFile(entry.getValue(), entry.getKey());
        }
    }

    private void createButtons(Composite composite) {
        Composite composite2 = this.mPage.getManagedForm().getToolkit().createComposite(composite);
        composite2.setLayoutData((Object)new GridData(2));
        composite2.setLayout((Layout)new GridLayout());
        Button button = this.mPage.getManagedForm().getToolkit().createButton(composite2, Messages.getString("PackageDescriptionSection.AddButton"), 8);
        button.setLayoutData((Object)new GridData(64));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IResource iResource;
                IProject iProject = PackageDescriptionSection.this.mPage.getProject();
                PackagePropertiesEditor packagePropertiesEditor = (PackagePropertiesEditor)PackageDescriptionSection.this.mPage.getEditor();
                ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(iProject, Messages.getString("PackageDescriptionSection.AddDescription"));
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                arrayList.add((IResource)iProject.getFolder("build"));
                arrayList.add((IResource)iProject.getFolder("bin"));
                arrayList.add((IResource)iProject.getFile("package.properties"));
                arrayList.addAll(packagePropertiesEditor.getModel().getBasicLibraries());
                arrayList.addAll(packagePropertiesEditor.getModel().getDialogLibraries());
                arrayList.addAll(packagePropertiesEditor.getModel().getContents());
                arrayList.addAll(packagePropertiesEditor.getModel().getDescriptionFiles().values());
                arrayList.addAll(UnoidlProjectHelper.getContainedFile(iProject));
                projectSelectionDialog.setFilteredElements(arrayList);
                if (0 == projectSelectionDialog.open() && (iResource = projectSelectionDialog.getSelected()) instanceof IFile) {
                    PackageDescriptionSection.this.mDescriptions.put((IFile)iResource, Locale.getDefault());
                    PackageDescriptionSection.this.mTableViewer.add((Object)iResource);
                    PackageDescriptionSection.this.mTableViewer.refresh();
                    PackageDescriptionSection.this.fireSectionModified();
                }
            }
        });
        Button button2 = this.mPage.getManagedForm().getToolkit().createButton(composite2, Messages.getString("PackageDescriptionSection.DelButton"), 8);
        button2.setLayoutData((Object)new GridData(64));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISelection iSelection = PackageDescriptionSection.this.mTableViewer.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    for (Object e : iStructuredSelection) {
                        PackageDescriptionSection.this.mDescriptions.remove(e);
                        PackageDescriptionSection.this.mTableViewer.remove(e);
                    }
                    PackageDescriptionSection.this.fireSectionModified();
                    PackageDescriptionSection.this.mTableViewer.refresh();
                }
            }
        });
    }

    private class DescrContentProvider
    implements IStructuredContentProvider {
        private DescrContentProvider() {
        }

        public Object[] getElements(Object object) {
            return PackageDescriptionSection.this.mDescriptions.keySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class DescrLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DescrLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            Image image = null;
            if (n == 0 && object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter(IWorkbenchAdapter.class);
                image = iWorkbenchAdapter.getImageDescriptor(object).createImage();
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            if (n == 0 && object instanceof IFile) {
                string = ((IResource)object).getProjectRelativePath().toOSString();
            } else if (n == 1) {
                string = ((Locale)PackageDescriptionSection.this.mDescriptions.get(object)).getDisplayName();
            }
            return string;
        }
    }

    private class DescrCellModifier
    implements ICellModifier {
        private DescrCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return string.equals(PackageDescriptionSection.P_LOCALE);
        }

        public Object getValue(Object object, String string) {
            Object var3_3 = null;
            if (string.equals(PackageDescriptionSection.P_LOCALE)) {
                var3_3 = PackageDescriptionSection.this.mDescriptions.get(object);
            }
            return var3_3;
        }

        public void modify(Object object, String string, Object object2) {
            Object object3;
            if (string.equals(PackageDescriptionSection.P_LOCALE) && object2 instanceof Locale && object instanceof TableItem && (object3 = ((TableItem)object).getData()) instanceof IFile) {
                PackageDescriptionSection.this.mDescriptions.put((IFile)object3, (Locale)object2);
                PackageDescriptionSection.this.mTableViewer.refresh(object3);
                PackageDescriptionSection.this.fireSectionModified();
            }
        }
    }
}

