/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.pack;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.pack.ContentsSection;
import org.libreoffice.ide.eclipse.core.editors.pack.LibsSection;
import org.libreoffice.ide.eclipse.core.editors.pack.PackageDescriptionSection;
import org.libreoffice.ide.eclipse.core.editors.pack.PackagePropertiesEditor;
import org.libreoffice.ide.eclipse.core.model.pack.PackagePropertiesModel;

public class PackageFormPage
extends FormPage {
    private ContentsSection mContents;
    private LibsSection mLibs;
    private PackageDescriptionSection mDescriptions;

    public PackageFormPage(FormEditor formEditor, String string) {
        super(formEditor, string, Messages.getString("PackagePropertiesFormPage.PackagePropertiesText"));
    }

    public IProject getProject() {
        IProject iProject = null;
        if (this.getEditorInput() instanceof IFileEditorInput) {
            iProject = ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
        }
        return iProject;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledForm.setText(Messages.getString("PackagePropertiesFormPage.PackagePropertiesText"));
        scrolledForm.getBody().setLayout((Layout)new GridLayout(2, true));
        this.mContents = new ContentsSection(this);
        this.mLibs = new LibsSection(this);
        this.mDescriptions = new PackageDescriptionSection(this);
        PackagePropertiesModel packagePropertiesModel = this.getModel();
        packagePropertiesModel.setQuiet(true);
        this.mContents.setContents();
        this.mLibs.setLibraries(packagePropertiesModel);
        this.mDescriptions.setDescriptions(packagePropertiesModel.getDescriptionFiles());
        packagePropertiesModel.setQuiet(false);
    }

    private PackagePropertiesModel getModel() {
        return ((PackagePropertiesEditor)this.getEditor()).getModel();
    }
}

