/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.pack;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.libreoffice.ide.eclipse.core.editors.pack.PackageFormPage;
import org.libreoffice.ide.eclipse.core.editors.utils.SourcePage;
import org.libreoffice.ide.eclipse.core.model.pack.PackagePropertiesModel;
import org.libreoffice.ide.eclipse.core.model.utils.IModelDataListener;

public class PackagePropertiesEditor
extends FormEditor {
    private SourcePage mSourcePage;
    private PackageFormPage mContentsPage;
    private PackagePropertiesModel mModel;
    private IModelDataListener mDataListener;
    private IDocumentListener mDocListener;

    protected void addPages() {
        try {
            this.mContentsPage = new PackageFormPage(this, "package");
            this.addPage((IFormPage)this.mContentsPage);
            this.mSourcePage = new SourcePage(this, "source", "package.properties");
            this.mSourcePage.init(this.getEditorSite(), this.getEditorInput());
            this.addPage(this.mSourcePage);
            IDocument iDocument = this.getDocument();
            if (iDocument != null) {
                this.addDocumentListener(iDocument);
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            this.setPartName(iFile.getProject().getName());
            this.mModel = this.getPackagePropertiesModel(iFile);
        }
    }

    public boolean isDirty() {
        return this.mModel.isDirty();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            if (this.mModel.write()) {
                this.mModel.setModified(true);
                this.writeToSource(this.mModel.writeToString());
                this.mModel.setModified(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            iDocument.removeDocumentListener(this.mDocListener);
        }
        this.mModel.removeDataListener(this.mDataListener);
        super.dispose();
    }

    public PackagePropertiesModel getModel() {
        return this.mModel;
    }

    private IDocument getDocument() {
        IDocument iDocument = null;
        if (this.mSourcePage.getDocumentProvider() instanceof TextFileDocumentProvider) {
            TextFileDocumentProvider textFileDocumentProvider = (TextFileDocumentProvider)this.mSourcePage.getDocumentProvider();
            iDocument = textFileDocumentProvider.getDocument((Object)this.mSourcePage.getEditorInput());
        }
        return iDocument;
    }

    private void addDocumentListener(IDocument iDocument) {
        IDocumentListener iDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            }

            public void documentChanged(DocumentEvent documentEvent) {
                if (!PackagePropertiesEditor.this.mModel.isModified()) {
                    PackagePropertiesEditor.this.mModel.reloadFromString(documentEvent.getDocument().get());
                    PackagePropertiesEditor.this.mModel.fireTreeRefresh();
                    PackagePropertiesEditor.this.editorDirtyStateChanged();
                }
            }
        };
        iDocument.addDocumentListener(iDocumentListener);
        this.mDocListener = iDocumentListener;
    }

    private PackagePropertiesModel getPackagePropertiesModel(IFile iFile) {
        final PackagePropertiesModel packagePropertiesModel = new PackagePropertiesModel(iFile);
        IModelDataListener iModelDataListener = new IModelDataListener(){

            @Override
            public void modelChanged() {
                if (packagePropertiesModel.isModified()) {
                    PackagePropertiesEditor.this.writeToSource(packagePropertiesModel.writeToString());
                }
                PackagePropertiesEditor.this.editorDirtyStateChanged();
            }

            @Override
            public void modelSaved() {
                PackagePropertiesEditor.this.editorDirtyStateChanged();
            }
        };
        packagePropertiesModel.addDataListener(iModelDataListener);
        this.mDataListener = iModelDataListener;
        return packagePropertiesModel;
    }

    private void writeToSource(String string) {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            iDocument.set(string);
        }
    }
}

