/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.syntax;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;

public class NonRuleBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument mDocument;
    protected TextAttribute mDefaultTextAttribute;

    public NonRuleBasedDamagerRepairer(TextAttribute textAttribute) {
        Assert.isNotNull((Object)textAttribute);
        this.mDefaultTextAttribute = textAttribute;
    }

    public void setDocument(IDocument iDocument) {
        this.mDocument = iDocument;
    }

    protected int endOfLineOf(int n) throws BadLocationException {
        int n2 = this.mDocument.getLength();
        IRegion iRegion = this.mDocument.getLineInformationOfOffset(n);
        if (n <= iRegion.getOffset() + iRegion.getLength()) {
            n2 = iRegion.getOffset() + iRegion.getLength();
        }
        int n3 = this.mDocument.getLineOfOffset(n);
        try {
            iRegion = this.mDocument.getLineInformation(n3 + 1);
            n2 = iRegion.getOffset() + iRegion.getLength();
        }
        catch (BadLocationException badLocationException) {
            n2 = this.mDocument.getLength();
        }
        return n2;
    }

    public IRegion getDamageRegion(ITypedRegion iTypedRegion, DocumentEvent documentEvent, boolean bl) {
        ITypedRegion iTypedRegion2 = iTypedRegion;
        if (!bl) {
            try {
                IRegion iRegion = this.mDocument.getLineInformationOfOffset(documentEvent.getOffset());
                int n = Math.max(iTypedRegion.getOffset(), iRegion.getOffset());
                int n2 = documentEvent.getLength();
                if (documentEvent.getText() == null) {
                    n2 = documentEvent.getText().length();
                }
                int n3 = documentEvent.getOffset() + n2;
                n3 = iRegion.getOffset() <= n3 && n3 <= iRegion.getOffset() + iRegion.getLength() ? iRegion.getOffset() + iRegion.getLength() : this.endOfLineOf(n3);
                n3 = Math.min(iTypedRegion.getOffset() + iTypedRegion.getLength(), n3);
                iTypedRegion2 = new Region(n, n3 - n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return iTypedRegion2;
    }

    public void createPresentation(TextPresentation textPresentation, ITypedRegion iTypedRegion) {
        this.addRange(textPresentation, iTypedRegion.getOffset(), iTypedRegion.getLength(), this.mDefaultTextAttribute);
    }

    protected void addRange(TextPresentation textPresentation, int n, int n2, TextAttribute textAttribute) {
        if (textAttribute != null) {
            textPresentation.addStyleRange(new StyleRange(n, n2, textAttribute.getForeground(), textAttribute.getBackground(), textAttribute.getStyle()));
        }
    }
}

