/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.syntax;

import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class RegexRule
implements IRule {
    private IToken mToken;
    private String mRegex;
    private int mCharReadNb = 0;
    private char[][] mDelimiters;

    public RegexRule(String string, IToken iToken) {
        this.mToken = iToken;
        this.mRegex = string;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n;
        this.mCharReadNb = 0;
        IToken iToken = Token.UNDEFINED;
        this.mDelimiters = iCharacterScanner.getLegalLineDelimiters();
        String string = new String();
        boolean bl = false;
        boolean bl2 = false;
        do {
            n = iCharacterScanner.read();
            string = string + Character.valueOf((char)n);
            ++this.mCharReadNb;
            if (!this.isEOL(n)) {
                if (Pattern.matches(this.mRegex, string)) {
                    bl2 = true;
                    continue;
                }
                if (!bl2) continue;
                bl = true;
                iCharacterScanner.unread();
                iToken = this.mToken;
                string = string.substring(0, string.length() - 2);
                continue;
            }
            if (!bl2) continue;
            bl = true;
            iToken = this.mToken;
        } while (!this.isEOL(n) && !bl);
        if (iToken != this.mToken) {
            for (int i = 0; i < this.mCharReadNb; ++i) {
                iCharacterScanner.unread();
            }
        }
        return iToken;
    }

    protected IToken getToken() {
        return this.mToken;
    }

    protected boolean isEOL(int n) {
        boolean bl = false;
        for (int i = 0; i < this.mDelimiters.length; ++i) {
            if (n != this.mDelimiters[i][0] && !this.isEOF(n)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean isEOF(int n) {
        boolean bl = false;
        if (-1 == n) {
            bl = true;
        }
        return bl;
    }
}

