/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;

public class ColorProvider {
    protected Map<String, Color> mColorTable = new HashMap<String, Color>();
    private IPreferenceStore mStore;
    private final IPropertyChangeListener mPropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ColorProvider.this.mColorTable.clear();
        }
    };

    public ColorProvider() {
        OOEclipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.mPropertyListener);
        this.mStore = OOEclipsePlugin.getDefault().getPreferenceStore();
    }

    public void dispose() {
        Iterator<Color> iterator = this.mColorTable.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        OOEclipsePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.mPropertyListener);
    }

    public Color getColor(String string) {
        Color color = this.mColorTable.get(string);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)this.mStore, (String)string));
            this.mColorTable.put(string, color);
        }
        return color;
    }
}

