/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.editors.utils;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.editors.Messages;
import org.libreoffice.ide.eclipse.core.editors.utils.ILocaleListener;
import org.libreoffice.ide.eclipse.core.gui.LocaleDialog;

public class LocaleSelector {
    private static final int LAYOUT_COLS = 4;
    private ComboViewer mLangList;
    private Button mAddBtn;
    private Button mDelBtn;
    private Locale mCurrentLocale;
    private ArrayList<Locale> mLocales;
    private ArrayList<ILocaleListener> mListeners = new ArrayList();

    public LocaleSelector(FormToolkit formToolkit, Composite composite) {
        this.mLocales = new ArrayList();
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(4, false));
        Label label = formToolkit.createSeparator(composite2, 256);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.createList(formToolkit, composite2);
        this.createButtons(composite2);
    }

    public void addListener(ILocaleListener iLocaleListener) {
        this.mListeners.add(iLocaleListener);
    }

    protected void removeListener(ILocaleListener iLocaleListener) {
        this.mListeners.remove(iLocaleListener);
    }

    protected Locale getCurrentLocale() {
        Locale locale = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mLangList.getSelection();
        if (!iStructuredSelection.isEmpty()) {
            locale = (Locale)iStructuredSelection.getFirstElement();
        }
        return locale;
    }

    public void loadLocales(ArrayList<Locale> arrayList) {
        for (Locale locale : this.mLocales) {
            this.mLangList.remove((Object)locale);
            this.fireDeleteLocale(locale);
        }
        this.mLocales.clear();
        this.mLocales.addAll(arrayList);
        for (Locale locale : this.mLocales) {
            this.mLangList.add((Object)locale);
            this.fireAddLocale(locale);
        }
        if (this.mLocales.size() > 0) {
            Locale locale = this.mLocales.get(0);
            this.mLangList.setSelection((ISelection)new StructuredSelection((Object)locale));
            this.fireUpdateLocale(locale);
        }
    }

    private void createList(FormToolkit formToolkit, Composite composite) {
        String string = Messages.getString("LocaleSelector.SelectedLocaleTitle");
        Label label = formToolkit.createLabel(composite, string);
        label.setLayoutData((Object)new GridData(32));
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(768));
        this.mLangList = new ComboViewer(combo);
        this.mLangList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mLangList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mLangList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (!iStructuredSelection.isEmpty()) {
                    LocaleSelector.this.mCurrentLocale = (Locale)iStructuredSelection.getFirstElement();
                    LocaleSelector.this.fireUpdateLocale(LocaleSelector.this.mCurrentLocale);
                }
            }
        });
    }

    private void createButtons(Composite composite) {
        this.mAddBtn = new Button(composite, 0);
        this.mAddBtn.setImage(OOEclipsePlugin.getImage("ADD"));
        this.mAddBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LocaleDialog localeDialog = new LocaleDialog();
                if (localeDialog.open() == 0) {
                    Locale locale = localeDialog.getLocale();
                    if (!LocaleSelector.this.mLocales.contains(locale)) {
                        LocaleSelector.this.mLocales.add(locale);
                        LocaleSelector.this.mLangList.add((Object)locale);
                        LocaleSelector.this.mDelBtn.setEnabled(true);
                        LocaleSelector.this.fireAddLocale(locale);
                    }
                    LocaleSelector.this.mLangList.setSelection((ISelection)new StructuredSelection((Object)locale), true);
                    LocaleSelector.this.fireUpdateLocale(locale);
                }
            }
        });
        this.mDelBtn = new Button(composite, 0);
        this.mDelBtn.setEnabled(false);
        this.mDelBtn.setImage(OOEclipsePlugin.getImage("DELETE"));
        this.mDelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Locale locale = LocaleSelector.this.getCurrentLocale();
                LocaleSelector.this.mLangList.remove((Object)locale);
                int n = LocaleSelector.this.mLocales.indexOf(locale) - 1;
                if (n < 0) {
                    n = 0;
                }
                LocaleSelector.this.mLocales.remove(locale);
                LocaleSelector.this.mDelBtn.setEnabled(!LocaleSelector.this.mLocales.isEmpty());
                LocaleSelector.this.fireDeleteLocale(locale);
                Locale locale2 = (Locale)LocaleSelector.this.mLocales.get(n);
                LocaleSelector.this.mLangList.setSelection((ISelection)new StructuredSelection((Object)locale2), true);
                LocaleSelector.this.fireUpdateLocale(LocaleSelector.this.getCurrentLocale());
            }
        });
    }

    private void fireUpdateLocale(Locale locale) {
        for (ILocaleListener iLocaleListener : this.mListeners) {
            iLocaleListener.selectLocale(locale);
        }
    }

    private void fireDeleteLocale(Locale locale) {
        for (ILocaleListener iLocaleListener : this.mListeners) {
            iLocaleListener.deleteLocale(locale);
        }
    }

    private void fireAddLocale(Locale locale) {
        for (ILocaleListener iLocaleListener : this.mListeners) {
            iLocaleListener.addLocale(locale);
        }
    }
}

