/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.export;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.libreoffice.ide.eclipse.core.Messages;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.export.AntScriptExportWizardPage;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;

public class AntScriptExportWizard
extends Wizard
implements IExportWizard {
    private static final String ANT_EXPORT_SETTINGS_KEY = "oxt.export";
    private boolean mHasNewDialogSettings;
    private AntScriptExportWizardPage mAntScriptPage;

    public AntScriptExportWizard() {
        IDialogSettings iDialogSettings = OOEclipsePlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(ANT_EXPORT_SETTINGS_KEY);
        if (iDialogSettings2 == null) {
            this.mHasNewDialogSettings = true;
        } else {
            this.mHasNewDialogSettings = false;
            this.setDialogSettings(iDialogSettings2);
        }
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        IUnoidlProject iUnoidlProject = null;
        Iterator iterator = iStructuredSelection.iterator();
        try {
            while (iterator.hasNext() && iUnoidlProject == null) {
                IResource iResource;
                Object e = iterator.next();
                if (!(e instanceof IAdaptable) || (iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class)) == null || !iResource.getProject().hasNature("org.libreoffice.ide.eclipse.core.unonature") || ProjectsManager.getProject(iResource.getProject().getName()).getLanguage() == null) continue;
                iUnoidlProject = ProjectsManager.getProject(iResource.getProject().getName());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.setWindowTitle(Messages.getString("AntScriptExportWizard.DialogTitle"));
        this.mAntScriptPage = new AntScriptExportWizardPage("page1", iUnoidlProject);
        this.addPage((IWizardPage)this.mAntScriptPage);
    }

    public boolean performFinish() {
        Object object;
        boolean bl = false;
        String string = this.mAntScriptPage.getPath();
        try {
            this.mAntScriptPage.createBuildScripts();
            this.mAntScriptPage.refreshProject();
            if (this.mHasNewDialogSettings) {
                object = OOEclipsePlugin.getDefault().getDialogSettings();
                IDialogSettings iDialogSettings = object.getSection(ANT_EXPORT_SETTINGS_KEY);
                iDialogSettings = object.addNewSection(ANT_EXPORT_SETTINGS_KEY);
                this.setDialogSettings(iDialogSettings);
            }
        }
        catch (Exception exception) {
            PluginLogger.error("The Ant Script couldn't be built", exception);
        }
        object = new File(string + "/build.xml");
        bl = ((File)object).exists();
        return bl;
    }
}

