/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.export;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.libreoffice.ide.eclipse.core.Messages;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.export.ProjectExportPart;
import org.libreoffice.ide.eclipse.core.gui.PackageContentSelector;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.language.LanguageExportPart;
import org.libreoffice.plugin.core.model.UnoPackage;

public class AntScriptExportWizardPage
extends WizardPage {
    private IUnoidlProject mSelectedProject;
    private LanguageExportPart mLangPart;
    private Combo mProjectsList;
    private boolean mCheckAntSectionDisplay = false;

    public AntScriptExportWizardPage(String string, IUnoidlProject iUnoidlProject) {
        super(string);
        this.setTitle(Messages.getString("AntScriptExportWizard.Title"));
        this.setDescription(Messages.getString("AntScriptExportWizard.Description"));
        this.mSelectedProject = iUnoidlProject;
    }

    public void createBuildScripts() {
        this.mLangPart.doFinish();
        this.mCheckAntSectionDisplay = false;
        ProjectExportPart.setCheckAntSectionDisplay(this.mCheckAntSectionDisplay);
    }

    public IUnoidlProject getProject() {
        return this.mSelectedProject;
    }

    public void setProject(IUnoidlProject iUnoidlProject) {
        this.mSelectedProject = iUnoidlProject;
        this.reloadLanguagePart();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite2);
        this.createProjectSelection();
        this.setPageComplete(this.checkPageCompletion());
        this.loadData();
    }

    private void loadData() {
        String[] stringArray = this.mProjectsList.getItems();
        for (int i = 0; this.mSelectedProject != null && i < stringArray.length; ++i) {
            if (!stringArray[i].equals(this.mSelectedProject.getName())) continue;
            this.mProjectsList.select(i);
        }
    }

    private void createProjectSelection() {
        Composite composite = (Composite)this.getControl();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("AntScriptExportWizard.Project"));
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ArrayList<String> arrayList = new ArrayList<String>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            for (IUnoidlProject iUnoidlProject : ProjectsManager.getProjects()) {
                if (!iWorkspaceRoot.getProject(iUnoidlProject.getName()).hasNature("org.libreoffice.ide.eclipse.core.unonature") || iUnoidlProject.getLanguage() == null) continue;
                arrayList.add(iUnoidlProject.getName());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.mProjectsList = new Combo(composite2, 12);
        this.mProjectsList.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mProjectsList.setItems(arrayList.toArray(new String[arrayList.size()]));
        this.mProjectsList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                int n = AntScriptExportWizardPage.this.mProjectsList.getSelectionIndex();
                if (n != -1) {
                    String string = AntScriptExportWizardPage.this.mProjectsList.getItem(n);
                    IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string);
                    AntScriptExportWizardPage.this.mSelectedProject = iUnoidlProject;
                    AntScriptExportWizardPage.this.setProject(iUnoidlProject);
                }
                AntScriptExportWizardPage.this.setPageComplete(AntScriptExportWizardPage.this.checkPageCompletion());
            }
        });
    }

    private boolean checkPageCompletion() {
        return this.mProjectsList.getSelectionIndex() != -1;
    }

    private void reloadLanguagePart() {
        if (this.mSelectedProject != null) {
            this.mLangPart = this.mSelectedProject.getLanguage().getExportBuildPart();
            if (this.mLangPart != null) {
                ProjectExportPart.setAntScriptExportPage(this);
                Composite composite = (Composite)this.getControl();
                if (composite != null) {
                    this.mLangPart.createControls(composite);
                    composite.layout();
                    this.mCheckAntSectionDisplay = true;
                    ProjectExportPart.setCheckAntSectionDisplay(this.mCheckAntSectionDisplay);
                }
            }
        }
    }

    public UnoPackage getPackageModel(String string) {
        UnoPackage unoPackage = null;
        try {
            File file = new File(string);
            unoPackage = PackageContentSelector.createPackage(this.mSelectedProject, file, new ArrayList());
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("AntScriptExportWizard.LibraryCreationError"), exception);
        }
        return unoPackage;
    }

    public void refreshProject() {
        try {
            String string = this.mSelectedProject.getName();
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            iProject.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getPath() {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mSelectedProject.getName());
        File file = iProject.getFile("package.properties").getLocation().toFile().getParentFile();
        return file.toString();
    }
}

