/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.export;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.libreoffice.ide.eclipse.core.Messages;
import org.libreoffice.ide.eclipse.core.export.AntScriptExportWizardPage;
import org.libreoffice.ide.eclipse.core.export.ProjectExportPageControl;
import org.libreoffice.ide.eclipse.core.model.language.LanguageExportPart;
import org.libreoffice.ide.eclipse.core.utils.TemplatesHelper;

public class ProjectExportPart
extends LanguageExportPart {
    public static final int HORIZONTAL_INDENT = 20;
    private static AntScriptExportWizardPage sAntScriptPage;
    private static boolean sAntSectionDisplay;
    private Composite mNameRow;
    private Label mNameRowLbl;
    private Label mNameRowValueLbl;
    private Label mTitleLbl;
    private ProjectExportPageControl mController;

    public static void setAntScriptExportPage(AntScriptExportWizardPage antScriptExportWizardPage) {
        sAntScriptPage = antScriptExportWizardPage;
    }

    public static void setCheckAntSectionDisplay(boolean bl) {
        sAntSectionDisplay = bl;
    }

    @Override
    public void createControls(Composite composite) {
        this.mController = new ProjectExportPageControl();
        this.mController.setSaveAntScript(true);
        if (!sAntSectionDisplay) {
            this.mTitleLbl = new Label(composite, 0);
            this.mTitleLbl.setText(Messages.getString("ProjectExportPart.Title"));
            this.mTitleLbl.setLayoutData((Object)new GridData(1, 1, false, false));
            Composite composite2 = new Composite(composite, 0);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.horizontalIndent = 20;
            composite2.setLayoutData((Object)gridData);
            composite2.setLayout((Layout)new GridLayout());
            this.mNameRow = new Composite(composite2, 0);
            this.mNameRow.setLayout((Layout)new GridLayout(2, false));
            gridData = new GridData(4, 1, true, false);
            gridData.horizontalIndent = 20;
            this.mNameRow.setLayoutData((Object)gridData);
            this.mNameRowLbl = new Label(this.mNameRow, 0);
            this.mNameRowLbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.mNameRowLbl.setText(Messages.getString("ProjectExportPart.AntFile"));
            this.mNameRowValueLbl = new Label(this.mNameRow, 0);
            this.mNameRowValueLbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.mNameRowValueLbl.setText(this.mController.getSavePath());
            this.mNameRowLbl.setEnabled(this.mController.isSavePathEnabled());
            this.mNameRowValueLbl.setEnabled(this.mController.isSavePathEnabled());
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void doFinish() {
        Object object;
        String string = sAntScriptPage.getPath();
        File file = new File(string + "/build.xml");
        boolean bl = false;
        if (file.exists()) {
            object = Display.getDefault().getActiveShell();
            bl = MessageDialog.openConfirm((Shell)object, (String)"Confirm", (String)"build.xml exists under the selected project.\nDo you wish to overwrite it?");
        } else {
            bl = true;
        }
        if (this.mController.getSaveAntScript() && bl) {
            object = sAntScriptPage.getProject();
            String string2 = object.getName();
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
            TemplatesHelper.copyTemplate(iProject, this.mController.getSavePath(), ProjectExportPart.class, new String(), string2);
            if (!object.hasBuildFile()) {
                object.createBuildProperties();
            }
        }
    }

    static {
        sAntSectionDisplay = false;
    }
}

