/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import java.util.Vector;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.libreoffice.ide.eclipse.core.gui.ITableElement;
import org.libreoffice.ide.eclipse.core.gui.Messages;

public class AbstractTable
extends Composite
implements ISelectionProvider {
    protected Table mTable;
    protected TableViewer mTableViewer;
    private Vector<ITableElement> mLines = new Vector();
    private Button mAddButton;
    private Button mRemoveButton;
    private String[] mColumnTitles;
    private int[] mColumnWidths;
    private String[] mColumnProperties;
    private String mTitle;

    public AbstractTable(Composite composite, String string, String[] stringArray, int[] nArray, String[] stringArray2) {
        super(composite, 0);
        this.mTitle = string;
        int n = stringArray.length;
        int n2 = nArray.length;
        int n3 = stringArray2.length;
        int n4 = Math.min(n, Math.min(n3, n2));
        this.mColumnProperties = new String[n4];
        this.mColumnTitles = new String[n4];
        this.mColumnWidths = new int[n4];
        for (int i = 0; i < n4; ++i) {
            this.mColumnProperties[i] = stringArray2[i];
            this.mColumnWidths[i] = nArray[i];
            this.mColumnTitles[i] = stringArray[i];
        }
        this.mColumnProperties = stringArray2;
        this.mColumnTitles = stringArray;
        this.mColumnWidths = nArray;
        this.createContent();
        this.createColumns();
    }

    public void dispose() {
        if (this.mLines != null) {
            this.mLines.clear();
        }
    }

    public Vector<ITableElement> getLines() {
        return this.mLines;
    }

    public void setToolTipText(String string) {
        this.mTableViewer.getTable().setToolTipText(string);
    }

    protected void addLine(ITableElement iTableElement) {
        this.mLines.add(iTableElement);
        this.mTableViewer.add((Object)iTableElement);
        this.mTableViewer.refresh();
    }

    protected void createContent() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 0);
        label.setText(this.mTitle);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.createTable();
        this.createTableViewer();
        this.createButtons();
        this.mTableViewer.setInput((Object)this);
    }

    protected CellEditor[] createCellEditors(Table table) {
        return null;
    }

    protected ITableElement addLine() {
        return null;
    }

    protected ITableElement removeLine() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mTableViewer.getSelection();
        ITableElement iTableElement = null;
        if (!iStructuredSelection.isEmpty() && iStructuredSelection.getFirstElement() instanceof ITableElement) {
            iTableElement = (ITableElement)iStructuredSelection.getFirstElement();
        }
        return iTableElement;
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
    }

    private void createTable() {
        this.mTable = new Table((Composite)this, 67588);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 2;
        this.mTable.setLayoutData((Object)gridData);
        this.mTable.setLinesVisible(false);
        this.mTable.setHeaderVisible(true);
    }

    private void createTableViewer() {
        this.mTableViewer = new TableViewer(this.mTable);
        this.mTableViewer.setColumnProperties(this.mColumnProperties);
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider());
        this.mTableViewer.setContentProvider((IContentProvider)new AbstractContentProvider());
        this.mTableViewer.setCellEditors(this.createCellEditors(this.mTable));
        this.mTableViewer.setCellModifier((ICellModifier)new AbstractCellModifier());
        this.mTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                AbstractTable.this.handleDoubleClick(doubleClickEvent);
            }
        });
    }

    private void createButtons() {
        this.mAddButton = new Button((Composite)this, 0);
        this.mAddButton.setText(Messages.getString("AbstractTable.Add"));
        GridData gridData = new GridData(258);
        this.mAddButton.setLayoutData((Object)gridData);
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ITableElement iTableElement = AbstractTable.this.addLine();
                if (null != iTableElement) {
                    AbstractTable.this.mLines.add(iTableElement);
                    AbstractTable.this.mTableViewer.add((Object)iTableElement);
                    AbstractTable.this.mTableViewer.refresh();
                }
            }
        });
        this.mRemoveButton = new Button((Composite)this, 0);
        this.mRemoveButton.setText(Messages.getString("AbstractTable.Del"));
        GridData gridData2 = new GridData(258);
        this.mRemoveButton.setLayoutData((Object)gridData2);
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ITableElement iTableElement = AbstractTable.this.removeLine();
                AbstractTable.this.mLines.remove(iTableElement);
                AbstractTable.this.mTableViewer.remove((Object)iTableElement);
                AbstractTable.this.mTableViewer.refresh();
            }
        });
    }

    private void createColumns() {
        int n = Math.min(this.mColumnWidths.length, this.mColumnTitles.length);
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = new TableColumn(this.mTable, 16400);
            tableColumn.setWidth(this.mColumnWidths[i]);
            tableColumn.setText(this.mColumnTitles[i]);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.mTableViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.mTableViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.mTableViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.mTableViewer.setSelection(iSelection);
    }

    private class AbstractLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AbstractLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            Image image = null;
            if (object instanceof ITableElement) {
                image = ((ITableElement)object).getImage(AbstractTable.this.mColumnProperties[n]);
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            if (object instanceof ITableElement) {
                string = ((ITableElement)object).getLabel(AbstractTable.this.mColumnProperties[n]);
            }
            return string;
        }
    }

    private class AbstractContentProvider
    implements IStructuredContentProvider {
        private AbstractContentProvider() {
        }

        public Object[] getElements(Object object) {
            return AbstractTable.this.mLines.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class AbstractCellModifier
    implements ICellModifier {
        private AbstractCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            boolean bl = false;
            if (object instanceof ITableElement) {
                bl = ((ITableElement)object).canModify(string);
            }
            return bl;
        }

        public Object getValue(Object object, String string) {
            Object object2 = null;
            if (object instanceof ITableElement) {
                object2 = ((ITableElement)object).getValue(string);
            }
            return object2;
        }

        public void modify(Object object, String string, Object object2) {
            TableItem tableItem = (TableItem)object;
            if (tableItem.getData() instanceof ITableElement) {
                ((ITableElement)tableItem.getData()).setValue(string, object2);
                AbstractTable.this.mTableViewer.refresh();
            }
        }
    }
}

