/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.libreoffice.ide.eclipse.core.gui.Messages;

public class ConnectionConfigPanel {
    private static final String[] TYPE_VALUES = new String[]{Messages.getString("ConnectionConfigPanel.Pipe"), Messages.getString("ConnectionConfigPanel.Socket")};
    private boolean mIsPipe = false;
    private String[] mPatterns = new String[TYPE_VALUES.length];
    private String mName = "somename";
    private String mHost = "localhost";
    private String mPort = "8100";
    private Combo mTypeList;
    private ArrayList<Composite> mDetails;
    private Composite mDetailsComposite;
    private Text mNameTxt;
    private Text mHostTxt;
    private Text mPortTxt;
    private StackLayout mStackLayout;

    public ConnectionConfigPanel(Composite composite) {
        this.createControls(composite);
    }

    public void setPatterns(String string, String string2) {
        this.mPatterns[0] = string;
        this.mPatterns[1] = string2;
    }

    public String getConnectionCode() {
        String string = null;
        string = this.mIsPipe ? MessageFormat.format(this.mPatterns[0], this.mName) : MessageFormat.format(this.mPatterns[1], this.mHost, this.mPort);
        return string;
    }

    protected void createControls(Composite composite) {
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            int n = ((GridLayout)layout).numColumns;
            Group group = new Group(composite, 0);
            group.setText(Messages.getString("ConnectionConfigPanel.GroupTitle"));
            GridData gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = n;
            group.setLayoutData((Object)gridData);
            group.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label((Composite)group, 0);
            label.setText(Messages.getString("ConnectionConfigPanel.CnxTypeLabel"));
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.mTypeList = new Combo((Composite)group, 12);
            this.mTypeList.setLayoutData((Object)new GridData(4, 1, true, false));
            this.mTypeList.setItems(TYPE_VALUES);
            int n2 = 1;
            if (this.mIsPipe) {
                n2 = 0;
            }
            this.mTypeList.select(n2);
            this.mTypeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ConnectionConfigPanel.this.mIsPipe = ConnectionConfigPanel.this.mTypeList.getSelectionIndex() == 0;
                    ConnectionConfigPanel.this.updateDetails();
                }
            });
            this.mDetails = new ArrayList();
            this.mDetailsComposite = new Composite((Composite)group, 0);
            gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 2;
            this.mDetailsComposite.setLayoutData((Object)gridData);
            this.mStackLayout = new StackLayout();
            this.mDetailsComposite.setLayout((Layout)this.mStackLayout);
            this.mDetails.add(this.createPipeControls());
            this.mDetails.add(this.createSocketControls());
            this.updateDetails();
        }
    }

    protected void updateDetails() {
        int n = 1;
        if (this.mIsPipe) {
            n = 0;
        }
        this.mStackLayout.topControl = (Control)this.mDetails.get(n);
        this.mDetailsComposite.layout();
    }

    private Composite createPipeControls() {
        Composite composite = new Composite(this.mDetailsComposite, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ConnectionConfigPanel.Name"));
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.mNameTxt = new Text(composite, 2052);
        this.mNameTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mNameTxt.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ConnectionConfigPanel.this.mName = ConnectionConfigPanel.this.mNameTxt.getText();
            }
        });
        this.mNameTxt.setText(this.mName);
        return composite;
    }

    private Composite createSocketControls() {
        Composite composite = new Composite(this.mDetailsComposite, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ConnectionConfigPanel.Host"));
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.mHostTxt = new Text(composite, 2052);
        this.mHostTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mHostTxt.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ConnectionConfigPanel.this.mHost = ConnectionConfigPanel.this.mHostTxt.getText();
            }
        });
        this.mHostTxt.setText(this.mHost);
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.getString("ConnectionConfigPanel.Port"));
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.mPortTxt = new Text(composite, 2052);
        this.mPortTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mPortTxt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                try {
                    if (verifyEvent.text.length() > 0) {
                        Integer.parseInt(verifyEvent.text);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    verifyEvent.doit = false;
                }
            }
        });
        this.mPortTxt.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ConnectionConfigPanel.this.mPort = ConnectionConfigPanel.this.mPortTxt.getText();
            }
        });
        this.mPortTxt.setText(this.mPort);
        return composite;
    }
}

