/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.AbstractTable;
import org.libreoffice.ide.eclipse.core.gui.ITableElement;
import org.libreoffice.ide.eclipse.core.gui.Messages;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.FileRow;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;
import org.libreoffice.ide.eclipse.core.gui.rows.TextRow;
import org.libreoffice.ide.eclipse.core.internal.model.AbstractOOo;
import org.libreoffice.ide.eclipse.core.internal.model.OOo;
import org.libreoffice.ide.eclipse.core.internal.model.URE;
import org.libreoffice.ide.eclipse.core.model.OOoContainer;
import org.libreoffice.ide.eclipse.core.model.config.IConfigListener;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;

public class OOoTable
extends AbstractTable {
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 200;
    private AbstractOOo mTmpOOo;

    public OOoTable(Composite composite) {
        super(composite, Messages.getString("OOoTable.Title"), new String[]{Messages.getString("OOoTable.NameTitle"), Messages.getString("OOoTable.PathTitle")}, new int[]{100, 200}, new String[]{"__ooo_name", "__ooo_path"});
        this.mTableViewer.setInput((Object)OOoContainer.getInstance());
        this.mTableViewer.setContentProvider((IContentProvider)new OOoContentProvider());
    }

    public void getPreferences() {
        OOoContainer.getInstance();
    }

    public void savePreferences() {
        OOoContainer.saveOOos();
    }

    @Override
    protected ITableElement addLine() {
        AbstractOOo abstractOOo = this.openDialog(null);
        OOoContainer.addOOo(abstractOOo);
        return abstractOOo;
    }

    @Override
    protected ITableElement removeLine() {
        ITableElement iTableElement = super.removeLine();
        if (null != iTableElement && iTableElement instanceof IOOo) {
            OOoContainer.delOOo((IOOo)((Object)iTableElement));
        }
        return iTableElement;
    }

    @Override
    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        if (!doubleClickEvent.getSelection().isEmpty()) {
            AbstractOOo abstractOOo = (AbstractOOo)((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
            abstractOOo = this.openDialog(abstractOOo);
            OOoContainer.updateOOo(abstractOOo.getName(), abstractOOo);
            this.mTableViewer.refresh();
        }
    }

    protected AbstractOOo openDialog(AbstractOOo abstractOOo) {
        Shell shell = Display.getDefault().getActiveShell();
        OOoDialog oOoDialog = new OOoDialog(shell, abstractOOo);
        if (0 == oOoDialog.open()) {
            AbstractOOo abstractOOo2 = this.mTmpOOo;
            this.mTmpOOo = null;
            if (null != abstractOOo) {
                try {
                    abstractOOo.setHome(abstractOOo2.getHome());
                    abstractOOo.setName(abstractOOo2.getName());
                }
                catch (InvalidConfigException invalidConfigException) {
                    PluginLogger.error(invalidConfigException.getLocalizedMessage(), invalidConfigException);
                }
            } else {
                abstractOOo = abstractOOo2;
            }
        }
        return abstractOOo;
    }

    class OOoContentProvider
    implements IStructuredContentProvider,
    IConfigListener {
        public OOoContentProvider() {
            if (null == OOoContainer.getInstance()) {
                OOoContainer.getInstance();
            }
        }

        public Object[] getElements(Object object) {
            return OOoContainer.toArray();
        }

        public void dispose() {
            OOoContainer.removeListener(this);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        @Override
        public void ConfigAdded(Object object) {
            if (object instanceof OOo) {
                OOoTable.this.mTableViewer.add(object);
                OOoTable.this.mTable.redraw();
            }
        }

        @Override
        public void ConfigRemoved(Object object) {
            if (null != object && object instanceof IOOo) {
                OOoTable.this.mTableViewer.remove(object);
            } else if (null != OOoTable.this.mTableViewer) {
                int n = 0;
                IOOo iOOo = (IOOo)OOoTable.this.mTableViewer.getElementAt(n);
                while (null != iOOo) {
                    OOoTable.this.mTableViewer.remove((Object)iOOo);
                }
            }
            OOoTable.this.mTable.redraw();
        }

        @Override
        public void ConfigUpdated(Object object) {
            if (object instanceof OOo) {
                OOoTable.this.mTableViewer.update(object, null);
            }
        }
    }

    class OOoDialog
    extends StatusDialog
    implements IFieldChangedListener {
        private static final String P_OOO_PATH = "__ooo_path";
        private static final String P_OOO_NAME = "__ooo_name";
        private static final int LAYOUT_COLUMNS = 3;
        private final Color mWHITE;
        private FileRow mOOopathRow;
        private TextRow mNameRow;
        private AbstractOOo mOOo;

        protected OOoDialog(Shell shell) {
            this(shell, null);
        }

        protected OOoDialog(Shell shell, AbstractOOo abstractOOo) {
            super(shell);
            this.mWHITE = new Color((Device)OOoTable.this.getDisplay(), 255, 255, 255);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.mOOo = abstractOOo;
            this.setBlockOnOpen(true);
            this.setTitle(Messages.getString("OOoTable.DialogTitle"));
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(3, false));
            composite2.setLayoutData((Object)new GridData(1808));
            Label label = new Label(composite2, 131072);
            label.setBackground(this.mWHITE);
            label.setImage(OOEclipsePlugin.getImage("OOO_DIALOG_IMAGE"));
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            this.mOOopathRow = new FileRow(composite2, P_OOO_PATH, Messages.getString("OOoTable.PathTitle"), true);
            this.mOOopathRow.setFieldChangedListener(this);
            if (null != this.mOOo) {
                this.mOOopathRow.setValue(this.mOOo.getHome());
            }
            this.mNameRow = new TextRow(composite2, P_OOO_NAME, Messages.getString("OOoTable.NameTitle"));
            this.mNameRow.setFieldChangedListener(this);
            if (null != this.mOOo && null != this.mOOo.getName()) {
                this.mNameRow.setValue(this.mOOo.getName());
            }
            return composite2;
        }

        protected void okPressed() {
            if (!this.mOOopathRow.getValue().isEmpty()) {
                this.isValid(null);
                super.okPressed();
            } else {
                this.updateStatus((IStatus)new Status(4, "org.libreoffice.ide.eclipse.core", 4, Messages.getString("OOoTable.MissingFieldError"), null));
            }
        }

        @Override
        public void fieldChanged(FieldEvent fieldEvent) {
            Button button = this.getButton(0);
            if (null != button) {
                if (fieldEvent.getProperty().equals(P_OOO_PATH)) {
                    button.setEnabled(this.isValid(fieldEvent.getProperty()));
                }
                if (fieldEvent.getProperty().equals(P_OOO_NAME)) {
                    boolean bl;
                    boolean bl2 = bl = !OOoContainer.containsName(fieldEvent.getValue());
                    if (bl) {
                        this.updateStatus((IStatus)new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null));
                    } else {
                        this.updateStatus((IStatus)new Status(2, "org.libreoffice.ide.eclipse.core", 2, Messages.getString("OOoSDKTable.NameExistsError"), null));
                    }
                }
            }
        }

        private boolean isValid(String string) {
            boolean bl = false;
            try {
                OOoTable.this.mTmpOOo = new OOo(this.mOOopathRow.getValue(), this.mNameRow.getValue());
                if (null != OOoTable.this.mTmpOOo.getName()) {
                    this.mNameRow.setValue(OOoTable.this.mTmpOOo.getName());
                }
                this.updateStatus((IStatus)new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null));
                bl = true;
            }
            catch (InvalidConfigException invalidConfigException) {
                try {
                    OOoTable.this.mTmpOOo = new URE(this.mOOopathRow.getValue(), this.mNameRow.getValue());
                    if (null != OOoTable.this.mTmpOOo.getName()) {
                        this.mNameRow.setValue(OOoTable.this.mTmpOOo.getName());
                    }
                    this.updateStatus((IStatus)new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null));
                    bl = true;
                }
                catch (InvalidConfigException invalidConfigException2) {
                    this.updateStatus((IStatus)new Status(4, "org.libreoffice.ide.eclipse.core", 4, Messages.getString("OOoTable.InvalidPathError"), (Throwable)invalidConfigException2));
                }
            }
            return bl;
        }
    }
}

