/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Image mBaseImage;
    private Point mSizeOfImage;
    private Image mImage;
    private int mLocation;

    public OverlayImageIcon(Image image, Image image2, int n) {
        this.mBaseImage = image;
        this.mImage = image2;
        this.mLocation = n;
        this.mSizeOfImage = new Point(image.getBounds().width, image.getBounds().height);
    }

    protected void drawCompositeImage(int n, int n2) {
        this.drawImage((ImageDataProvider)this.createCachedImageDataProvider(this.mBaseImage), 0, 0);
        CompositeImageDescriptor.CachedImageDataProvider cachedImageDataProvider = this.createCachedImageDataProvider(this.mImage);
        switch (this.mLocation) {
            case 0: {
                this.drawImage((ImageDataProvider)cachedImageDataProvider, 0, 0);
                break;
            }
            case 1: {
                this.drawImage((ImageDataProvider)cachedImageDataProvider, this.mSizeOfImage.x - this.mImage.getBounds().width, 0);
                break;
            }
            case 2: {
                this.drawImage((ImageDataProvider)cachedImageDataProvider, 0, this.mSizeOfImage.y - this.mImage.getBounds().height);
                break;
            }
            case 3: {
                this.drawImage((ImageDataProvider)cachedImageDataProvider, this.mSizeOfImage.x - this.mImage.getBounds().width, this.mSizeOfImage.y - this.mImage.getBounds().height);
            }
        }
    }

    protected Point getSize() {
        return this.mSizeOfImage;
    }

    public Image getImage() {
        return this.createImage();
    }
}

