/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.language.ILanguageBuilder;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;
import org.libreoffice.ide.eclipse.core.utils.FilesFinder;
import org.libreoffice.plugin.core.model.UnoPackage;

public class PackageContentSelector
extends Composite {
    private ResourceTreeAndListGroup mResourceGroup;
    private IUnoidlProject mProject;

    public PackageContentSelector(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.mResourceGroup = new ResourceTreeAndListGroup((Composite)this, new ArrayList(), this.getResourceProvider(3), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode((Composite)this));
    }

    public void setProject(IUnoidlProject iUnoidlProject) {
        this.mProject = iUnoidlProject;
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProject.getName());
        this.mResourceGroup.setRoot((Object)iProject);
    }

    public void loadDefaults() {
        List<IFile> list = PackageContentSelector.getDefaultContent(this.mProject);
        for (IFile iFile : list) {
            this.mResourceGroup.initialCheckListItem((Object)iFile);
            this.mResourceGroup.initialCheckTreeItem((Object)iFile);
        }
    }

    public List<?> getSelected() {
        return this.mResourceGroup.getAllWhiteCheckedItems();
    }

    public void setSelected(List<IResource> list) {
        for (IResource iResource : list) {
            this.mResourceGroup.initialCheckTreeItem((Object)iResource);
        }
    }

    public static List<IFile> getDefaultContent(IUnoidlProject iUnoidlProject) {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        FilesFinder filesFinder = new FilesFinder(new String[]{"xcu", "xcs"});
        try {
            filesFinder.addExclude(iUnoidlProject.getDistFolder().getFullPath());
            iProject.accept((IResourceVisitor)filesFinder);
        }
        catch (CoreException coreException) {
            PluginLogger.error("Could not visit the project's content.", coreException);
        }
        return filesFinder.getResults();
    }

    public static UnoPackage createPackage(IUnoidlProject iUnoidlProject, File file, List<?> list) throws Exception {
        File file2;
        Object object;
        UnoPackage unoPackage = null;
        File file3 = SystemHelper.getFile(iUnoidlProject);
        IFile iFile = null;
        ILanguageBuilder iLanguageBuilder = iUnoidlProject.getLanguage().getLanguageBuilder();
        iFile = iLanguageBuilder.createLibrary(iUnoidlProject);
        unoPackage = UnoidlProjectHelper.createMinimalUnoPackage(iUnoidlProject, file);
        if (iFile != null && iFile.exists()) {
            unoPackage.addToClean(SystemHelper.getFile((IResource)iFile));
            object = SystemHelper.getFile((IResource)iFile);
            unoPackage.addFile(UnoPackage.getPathRelativeToBase((File)object, file3), (File)object);
        }
        if ((object = iUnoidlProject.getFile("description.xml")).exists()) {
            file2 = SystemHelper.getFile((IResource)object);
            unoPackage.addContent(UnoPackage.getPathRelativeToBase(file2, file3), file2);
        }
        if ((file2 = iUnoidlProject.getComponentsFile()).exists()) {
            File file4 = SystemHelper.getFile((IResource)file2);
            unoPackage.addContent(UnoPackage.getPathRelativeToBase(file4, file3), file4);
        }
        for (Object e : list) {
            if (!(e instanceof IResource)) continue;
            File file5 = SystemHelper.getFile((IResource)e);
            unoPackage.addContent(UnoPackage.getPathRelativeToBase(file5, file3), file5);
        }
        return unoPackage;
    }

    private ITreeContentProvider getResourceProvider(final int n) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                ArrayList<IResource> arrayList;
                block5: {
                    block4: {
                        arrayList = new ArrayList<IResource>();
                        if (!(object instanceof ArrayList)) break block4;
                        ArrayList arrayList2 = (ArrayList)object;
                        for (Object e : arrayList2) {
                            if (!(e instanceof IResource)) continue;
                            arrayList.add((IResource)e);
                        }
                        break block5;
                    }
                    if (!(object instanceof IContainer)) break block5;
                    IResource[] iResourceArray = null;
                    try {
                        iResourceArray = ((IContainer)object).members();
                        for (int i = 0; i < iResourceArray.length; ++i) {
                            if ((iResourceArray[i].getType() & n) <= 0 || PackageContentSelector.this.isHiddenResource(iResourceArray[i])) continue;
                            arrayList.add(iResourceArray[i]);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return arrayList.toArray();
            }
        };
    }

    private boolean isHiddenResource(IResource iResource) {
        IFolder[] iFolderArray;
        boolean bl = false;
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject(iResource.getProject().getName());
        bl |= iUnoidlProject.getFolder(iUnoidlProject.getBuildPath()).equals((Object)iResource);
        for (IFolder iFolder : iFolderArray = iUnoidlProject.getBinFolders()) {
            bl |= iFolder.equals((Object)iResource);
        }
        bl |= iResource.getName().startsWith(".");
        bl |= iResource.getName().equals("description.xml");
        bl |= iResource.getName().equals("MANIFEST.MF");
        bl |= iResource.getName().equals("manifest.xml");
        return bl |= iResource.getName().equals("types.rdb");
    }
}

