/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.libreoffice.ide.eclipse.core.gui.Messages;

public class ProjectSelectionDialog
extends Dialog {
    private TreeViewer mTreeViewer;
    private IProject mProject;
    private String mDescription;
    private List<IResource> mNotShownResources = new ArrayList<IResource>();
    private boolean mFoldersOnly = false;
    private IResource mSelected;

    public ProjectSelectionDialog(IProject iProject, String string) {
        super(Display.getDefault().getActiveShell());
        this.mProject = iProject;
        this.mDescription = string;
        this.setShellStyle(65552);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ProjectSelectionDialog.Title"));
    }

    public void setShowOnlyFolders(boolean bl) {
        this.mFoldersOnly = bl;
    }

    public IResource getSelected() {
        return this.mSelected;
    }

    public void setFilteredElements(List<IResource> list) {
        if (this.mNotShownResources != null) {
            this.mNotShownResources.clear();
        }
        this.mNotShownResources = list;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        Label label = new Label(composite2, 64);
        label.setLayoutData((Object)new GridData(768));
        label.setText(this.mDescription);
        this.mTreeViewer = new TreeViewer(composite2);
        this.mTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.mTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.mTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                boolean bl = true;
                if (object2 instanceof IAdaptable) {
                    IFile iFile;
                    IAdaptable iAdaptable = (IAdaptable)object2;
                    boolean bl2 = bl = iAdaptable.getAdapter(IFolder.class) != null;
                    if (!ProjectSelectionDialog.this.mFoldersOnly && (iFile = (IFile)iAdaptable.getAdapter(IFile.class)) != null) {
                        boolean bl3 = bl = !iFile.getName().startsWith(".");
                    }
                    if (bl && ProjectSelectionDialog.this.mNotShownResources.contains(object2)) {
                        bl = false;
                    }
                }
                return bl;
            }
        });
        this.mTreeViewer.setInput((Object)this.mProject);
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    Object object = iStructuredSelection.getFirstElement();
                    if (object instanceof IResource) {
                        ProjectSelectionDialog.this.mSelected = (IResource)object;
                    } else {
                        ProjectSelectionDialog.this.mSelected = null;
                    }
                }
            }
        });
        return composite2;
    }
}

