/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.AbstractTable;
import org.libreoffice.ide.eclipse.core.gui.ITableElement;
import org.libreoffice.ide.eclipse.core.gui.Messages;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.FileRow;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;
import org.libreoffice.ide.eclipse.core.gui.rows.TextRow;
import org.libreoffice.ide.eclipse.core.internal.model.SDK;
import org.libreoffice.ide.eclipse.core.model.SDKContainer;
import org.libreoffice.ide.eclipse.core.model.config.IConfigListener;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;

public class SDKTable
extends AbstractTable {
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 200;
    private SDK mTmpSdk;

    public SDKTable(Composite composite) {
        super(composite, Messages.getString("SDKTable.Title"), new String[]{Messages.getString("SDKTable.NameTitle"), Messages.getString("SDKTable.PathTitle")}, new int[]{100, 200}, new String[]{"__sdk_name", "__sdk_path"});
        this.mTableViewer.setInput((Object)SDKContainer.getInstance());
        this.mTableViewer.setContentProvider((IContentProvider)new SDKContentProvider());
    }

    public void getPreferences() {
        SDKContainer.getInstance();
    }

    public void savePreferences() {
        SDKContainer.saveSDKs();
    }

    @Override
    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        if (!doubleClickEvent.getSelection().isEmpty()) {
            SDK sDK = (SDK)((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
            sDK = this.openDialog(sDK);
            SDKContainer.updateSDK(sDK.getName(), sDK);
            this.mTableViewer.refresh();
        }
    }

    @Override
    protected ITableElement addLine() {
        SDK sDK = this.openDialog(null);
        SDKContainer.addSDK(sDK);
        return sDK;
    }

    @Override
    protected ITableElement removeLine() {
        ITableElement iTableElement = super.removeLine();
        if (null != iTableElement && iTableElement instanceof SDK) {
            SDKContainer.delSDK((SDK)iTableElement);
        }
        return iTableElement;
    }

    protected SDK openDialog(SDK sDK) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SDKDialog sDKDialog = new SDKDialog(shell, sDK);
        if (0 == sDKDialog.open()) {
            SDK sDK2 = this.mTmpSdk;
            this.mTmpSdk = null;
            if (null != sDK) {
                try {
                    sDK.initialize(sDK2.getHome(), sDK2.getName());
                }
                catch (InvalidConfigException invalidConfigException) {
                    PluginLogger.error(invalidConfigException.getLocalizedMessage(), invalidConfigException);
                }
            } else {
                sDK = sDK2;
            }
        }
        return sDK;
    }

    class SDKContentProvider
    implements IStructuredContentProvider,
    IConfigListener {
        public SDKContentProvider() {
            if (null == SDKContainer.getInstance()) {
                SDKContainer.getInstance();
            }
        }

        public Object[] getElements(Object object) {
            return SDKContainer.toArray();
        }

        public void dispose() {
            SDKContainer.removeListener(this);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        @Override
        public void ConfigAdded(Object object) {
            if (object instanceof SDK) {
                SDKTable.this.mTableViewer.add(object);
                SDKTable.this.mTable.redraw();
            }
        }

        @Override
        public void ConfigRemoved(Object object) {
            if (null != object && object instanceof SDK) {
                SDKTable.this.mTableViewer.remove(object);
            } else if (null != SDKTable.this.mTableViewer) {
                int n = 0;
                SDK sDK = (SDK)SDKTable.this.mTableViewer.getElementAt(n);
                while (null != sDK) {
                    SDKTable.this.mTableViewer.remove((Object)sDK);
                }
            }
            SDKTable.this.mTable.redraw();
        }

        @Override
        public void ConfigUpdated(Object object) {
            if (object instanceof SDK) {
                SDKTable.this.mTableViewer.update(object, null);
            }
        }
    }

    class SDKDialog
    extends StatusDialog
    implements IFieldChangedListener {
        private static final String P_SDK_PATH = "__sdk_path";
        private static final int LAYOUT_COLUMNS = 3;
        private FileRow mSdkpathRow;
        private TextRow mSdkNameRow;
        private SDK mSdk;
        private final Color mWHITE;

        protected SDKDialog(Shell shell) {
            this(shell, null);
        }

        protected SDKDialog(Shell shell, SDK sDK) {
            super(shell);
            this.mWHITE = new Color((Device)SDKTable.this.getDisplay(), 255, 255, 255);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.mSdk = sDK;
            this.setBlockOnOpen(true);
            this.setTitle(Messages.getString("SDKTable.DialogTitle"));
        }

        protected Control createDialogArea(Composite composite) {
            Button button;
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(3, false));
            composite2.setLayoutData((Object)new GridData(1808));
            Label label = new Label(composite2, 131072);
            label.setBackground(this.mWHITE);
            label.setImage(OOEclipsePlugin.getImage("SDK_DIALOG_IMAGE"));
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            this.mSdkpathRow = new FileRow(composite2, P_SDK_PATH, Messages.getString("SDKTable.PathTitle"), true);
            this.mSdkpathRow.setFieldChangedListener(this);
            if (null != this.mSdk) {
                this.mSdkpathRow.setValue(this.mSdk.getHome());
            }
            this.mSdkNameRow = new TextRow(composite2, "", Messages.getString("SDKTable.NameTitle"));
            this.mSdkNameRow.setFieldChangedListener(this);
            if (null != this.mSdk && null != this.mSdk.getName()) {
                this.mSdkNameRow.setValue(this.mSdk.getName());
            }
            if (null != (button = this.getButton(0))) {
                button.setEnabled(this.isValid(null));
            }
            return composite2;
        }

        protected void okPressed() {
            if (!this.mSdkpathRow.getValue().equals("")) {
                this.isValid(null);
                super.okPressed();
            } else {
                this.updateStatus((IStatus)new Status(4, "org.libreoffice.ide.eclipse.core", 4, Messages.getString("SDKTable.MissingFieldError"), null));
            }
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }

        @Override
        public void fieldChanged(FieldEvent fieldEvent) {
            Button button = this.getButton(0);
            if (null != button) {
                if (fieldEvent.getProperty().equals(P_SDK_PATH)) {
                    button.setEnabled(this.isValid(fieldEvent.getProperty()));
                }
                if (fieldEvent.getProperty().equals(P_SDK_PATH)) {
                    boolean bl;
                    boolean bl2 = bl = !SDKContainer.containsName(fieldEvent.getValue());
                    if (bl) {
                        this.updateStatus((IStatus)new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null));
                    } else {
                        this.updateStatus((IStatus)new Status(2, "org.libreoffice.ide.eclipse.core", 2, Messages.getString("OOoSDKTable.NameExistsError"), null));
                    }
                }
            }
        }

        private boolean isValid(String string) {
            boolean bl = false;
            try {
                SDKTable.this.mTmpSdk = new SDK(this.mSdkpathRow.getValue(), this.mSdkNameRow.getValue());
                if (null != SDKTable.this.mTmpSdk.getName()) {
                    this.mSdkNameRow.setValue(SDKTable.this.mTmpSdk.getName());
                }
                this.updateStatus((IStatus)new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null));
                bl = true;
            }
            catch (InvalidConfigException invalidConfigException) {
                if ((string == null || string.equals(P_SDK_PATH)) && 0 == invalidConfigException.getErrorCode()) {
                    this.updateStatus((IStatus)new Status(4, "org.libreoffice.ide.eclipse.core", 4, invalidConfigException.getMessage(), (Throwable)invalidConfigException));
                }
                this.updateStatus((IStatus)new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", (Throwable)invalidConfigException));
            }
            return bl;
        }
    }
}

