/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.libreoffice.ide.eclipse.core.unotypebrowser.InternalUnoType;
import org.libreoffice.ide.eclipse.core.unotypebrowser.UnoTypeBrowser;

public class TypeCellEditor
extends TextCellEditor {
    private Button mButton;
    private boolean mDialogOpened = false;
    private int mType = 0;
    private boolean mIncludeSequences = false;
    private boolean mIncludeSimpleTypes = false;
    private boolean mIncludeVoid = true;

    public TypeCellEditor(Composite composite, int n) {
        super(composite, 0);
        if (n >= 0 && n <= 2047) {
            this.mType = n;
        }
    }

    public void includeSequences(boolean bl) {
        this.mIncludeSequences = bl;
    }

    public void includeSimpleTypes(boolean bl) {
        this.mIncludeSimpleTypes = bl;
    }

    public void includeVoid(boolean bl) {
        this.mIncludeVoid = bl;
    }

    protected Object openDialogBox(Composite composite) {
        InternalUnoType internalUnoType;
        Object object = this.getValue();
        int n = this.mType & 0x7FFFFFFE;
        UnoTypeBrowser unoTypeBrowser = new UnoTypeBrowser(composite.getShell(), n);
        if (0 == unoTypeBrowser.open() && null != (internalUnoType = unoTypeBrowser.getSelectedType())) {
            int n2 = this.text.getCaretPosition();
            this.text.insert(internalUnoType.getFullName().replaceAll("\\.", "::"));
            this.text.setFocus();
            this.text.setSelection(n2 + internalUnoType.getFullName().length());
            object = this.text.getText().trim();
        }
        return object;
    }

    protected void focusLost() {
        Control control;
        if (!(this.mDialogOpened || this.text.equals(control = Display.getDefault().getFocusControl()) || this.mButton.equals(control))) {
            super.focusLost();
        }
    }

    protected Control createControl(Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)this.getLayoutData());
        composite2.setLayout((Layout)new DialogCellLayout());
        super.createControl(composite2);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && (keyEvent.stateMask & 0x40000) != 0) {
                    int n;
                    int n2 = TypeCellEditor.this.text.getCaretPosition();
                    String string = TypeCellEditor.this.text.getText(0, n2);
                    if ("sequence".startsWith(string.substring(n = TypeCellEditor.this.getStartOfWord(n2, string), n2)) && TypeCellEditor.this.mIncludeSequences) {
                        String string2 = "sequence".substring(n2 - n) + "<>";
                        TypeCellEditor.this.text.insert(string2);
                        TypeCellEditor.this.setValue(TypeCellEditor.this.text.getText().trim());
                        TypeCellEditor.this.text.setSelection(n2 + string2.length() - 1);
                        keyEvent.doit = false;
                    } else if (TypeCellEditor.this.mIncludeSimpleTypes) {
                        String[] stringArray;
                        for (String string3 : stringArray = new String[]{"unsigned ", "string", "short", "long", "hyper", "double", "float", "any", "void", "char", "type", "boolean"}) {
                            if (string3.equals("void") && !TypeCellEditor.this.mIncludeVoid || !string3.startsWith(string.substring(n, n2))) continue;
                            String string4 = string3.substring(n2 - n);
                            TypeCellEditor.this.text.insert(string4);
                            TypeCellEditor.this.setValue(TypeCellEditor.this.text.getText().trim());
                            TypeCellEditor.this.text.setSelection(n2 + string4.length());
                            keyEvent.doit = false;
                            break;
                        }
                    }
                }
            }
        });
        this.mButton = new Button(composite2, 0);
        this.mButton.setText("...");
        this.mButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TypeCellEditor.this.focusLost();
            }
        });
        this.mButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TypeCellEditor.this.mDialogOpened = true;
                Object object = TypeCellEditor.this.openDialogBox(composite2);
                TypeCellEditor.this.mDialogOpened = false;
                if (object != null) {
                    boolean bl = TypeCellEditor.this.isCorrect(object);
                    if (bl) {
                        TypeCellEditor.this.markDirty();
                        TypeCellEditor.this.doSetValue(object);
                    } else {
                        TypeCellEditor.this.setErrorMessage(MessageFormat.format(TypeCellEditor.this.getErrorMessage(), object.toString()));
                    }
                    TypeCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        return composite2;
    }

    private int getStartOfWord(int n, String string) {
        int n2;
        for (n2 = n - 1; string.charAt(n2) >= 'a' && string.charAt(n2) <= 'z' && n2 > 0; --n2) {
        }
        if (n2 != 0) {
            ++n2;
        }
        return n2;
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Point point = TypeCellEditor.this.mButton.computeSize(-1, -1, bl);
            if (TypeCellEditor.this.text != null) {
                TypeCellEditor.this.text.setBounds(0, 0, rectangle.width - point.x, rectangle.height);
            }
            TypeCellEditor.this.mButton.setBounds(rectangle.width - point.x, 0, point.x, rectangle.height);
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Point point = new Point(n, n2);
            if (n == -1 || n2 == -1) {
                Point point2 = TypeCellEditor.this.text.computeSize(-1, -1, bl);
                Point point3 = TypeCellEditor.this.mButton.computeSize(-1, -1, bl);
                point = new Point(point3.x, Math.max(point2.y, point3.y));
            }
            return point;
        }
    }
}

