/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.gui.OverlayImageIcon;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;

public class UnoidlDecorator
extends LabelProvider
implements ILabelDecorator {
    public Image decorateImage(Image image, Object object) {
        Image image2 = null;
        if (this.isIdlFolder(object)) {
            image2 = new OverlayImageIcon(image, OOEclipsePlugin.getImage("IDL_MODIFIER"), 0).getImage();
        } else if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            try {
                if (iProject.hasNature("org.libreoffice.ide.eclipse.core.unonature")) {
                    image2 = new OverlayImageIcon(image, OOEclipsePlugin.getImage("PRJ_MODIFIER"), 3).getImage();
                }
            }
            catch (CoreException coreException) {}
        } else if (this.isDbFolder(object)) {
            image2 = new OverlayImageIcon(image, OOEclipsePlugin.getImage("DB_MODIFIER"), 0).getImage();
        }
        return image2;
    }

    public String decorateText(String string, Object object) {
        if (this.isIdlFolder(object)) {
            string = string.replaceAll("\\.", "/");
        }
        return string;
    }

    private boolean isIdlFolder(Object object) {
        boolean bl = false;
        if (object instanceof IResource) {
            IResource iResource = (IResource)object;
            try {
                if (2 == iResource.getType()) {
                    IProject iProject = iResource.getProject();
                    IUnoidlProject iUnoidlProject = ProjectsManager.getProject(iProject.getName());
                    IPath iPath = iUnoidlProject.getIdlPath();
                    IPath iPath2 = iResource.getProjectRelativePath();
                    bl = iPath2.toOSString().startsWith(iPath.toOSString());
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isDbFolder(Object object) {
        boolean bl = false;
        if (object instanceof IFolder) {
            try {
                IFolder iFolder = (IFolder)object;
                IUnoidlProject iUnoidlProject = ProjectsManager.getProject(iFolder.getProject().getName());
                if (iFolder.getProjectRelativePath().toString().startsWith(iUnoidlProject.getUrdPath().toString())) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }
}

