/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui.rows;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.libreoffice.ide.eclipse.core.gui.AbstractTable;
import org.libreoffice.ide.eclipse.core.gui.rows.ChoiceRow;
import org.libreoffice.ide.eclipse.core.gui.rows.Messages;
import org.libreoffice.ide.eclipse.core.model.config.IConfigListener;

public abstract class AbstractConfigRow
extends ChoiceRow {
    private IConfigListener mConfigListener = new ConfigListener();

    public AbstractConfigRow(final Composite composite, String string, String string2, Object object) {
        super(composite, string, Messages.getString("AbstractConfigRow.Label"), string2, true);
        this.addListener(this.mConfigListener);
        this.setLabel(this.getRowLabel());
        this.setBrowseSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                TableDialog tableDialog = new TableDialog(composite.getShell());
                tableDialog.create();
                tableDialog.open();
            }
        });
        this.fillRow();
        if (object != null) {
            this.select(this.getElementName(object));
        } else {
            this.select(0);
        }
    }

    public void dispose() {
        this.removeListener(this.mConfigListener);
    }

    protected abstract void addListener(IConfigListener var1);

    protected abstract void removeListener(IConfigListener var1);

    protected abstract String getRowLabel();

    protected abstract String[] getConfigValues();

    protected abstract String getElementName(Object var1);

    private void fillRow() {
        String[] stringArray = this.getConfigValues();
        this.removeAll();
        this.addAll(stringArray);
    }

    protected abstract String getTableDialogTitle();

    protected abstract AbstractTable createTable(Composite var1);

    protected abstract void savePreferences();

    private class ConfigListener
    implements IConfigListener {
        private ConfigListener() {
        }

        @Override
        public void ConfigAdded(Object object) {
            AbstractConfigRow.this.fillRow();
            AbstractConfigRow.this.select(AbstractConfigRow.this.getElementName(object));
        }

        @Override
        public void ConfigRemoved(Object object) {
            String string = AbstractConfigRow.this.getValue();
            AbstractConfigRow.this.fillRow();
            if (object != null && !string.equals(AbstractConfigRow.this.getElementName(object))) {
                AbstractConfigRow.this.select(string);
            }
        }

        @Override
        public void ConfigUpdated(Object object) {
            AbstractConfigRow.this.fillRow();
            AbstractConfigRow.this.select(AbstractConfigRow.this.getElementName(object));
        }
    }

    private class TableDialog
    extends Dialog {
        TableDialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setBlockOnOpen(true);
            shell.setText(AbstractConfigRow.this.getTableDialogTitle());
        }

        protected Control createDialogArea(Composite composite) {
            AbstractConfigRow.this.createTable(composite);
            return composite;
        }

        protected void okPressed() {
            super.okPressed();
            AbstractConfigRow.this.savePreferences();
        }
    }
}

