/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui.rows;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.LabeledRow;

public class BooleanRow
extends LabeledRow {
    private boolean mValue;

    public BooleanRow(Composite composite, String string, String string2) {
        super(string);
        Button button = new Button(composite, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BooleanRow.this.toggleValue();
            }
        });
        button.setText(string2);
        Label label = new Label(composite, 0);
        this.createContent(composite, (Control)button, (Control)label, null, false);
    }

    @Override
    public void setLabel(String string) {
        ((Label)this.mField).setText(string);
    }

    @Override
    public void setTooltip(String string) {
        ((Button)this.mLabel).setToolTipText(string);
    }

    public void setValue(boolean bl) {
        if (this.mValue != bl) {
            ((Button)this.mLabel).setSelection(bl);
            this.toggleValue();
        }
    }

    public void toggleValue() {
        this.mValue = !this.mValue;
        this.fireFieldChangedEvent(new FieldEvent(this.mProperty, this.getValue()));
    }

    public boolean getBooleanValue() {
        return this.mValue;
    }

    @Override
    public String getValue() {
        return Boolean.toString(this.mValue);
    }

    @Override
    public void setEnabled(boolean bl) {
        ((Button)this.mLabel).setEnabled(bl);
    }
}

