/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui.rows;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.LabeledRow;

public class ChoiceRow
extends LabeledRow {
    private Hashtable<String, String> mTranslations;
    private ArrayList<String> mItems;
    private int mSelected;

    public ChoiceRow(Composite composite, String string, String string2, String string3, boolean bl) {
        super(string);
        int n = 1;
        this.mTranslations = new Hashtable();
        this.mItems = new ArrayList();
        this.mSelected = -1;
        Label label = null;
        if (string2 != null) {
            label = new Label(composite, 0);
            label.setText(string2);
            ++n;
        }
        Combo combo = new Combo(composite, 8);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChoiceRow.this.mSelected = ((Combo)ChoiceRow.this.mField).getSelectionIndex();
                FieldEvent fieldEvent = new FieldEvent(ChoiceRow.this.mProperty, ChoiceRow.this.getValue());
                ChoiceRow.this.fireFieldChangedEvent(fieldEvent);
            }
        });
        this.createContent(composite, (Control)label, (Control)combo, string3, bl);
        if (this.mBrowse != null) {
            ++n;
        }
        GridData gridData = new GridData(800);
        gridData.horizontalSpan = ((GridLayout)composite.getLayout()).numColumns - n + 1;
        combo.setLayoutData((Object)gridData);
    }

    public void setBrowseSelectionListener(SelectionListener selectionListener) {
        if (null != this.mBrowse) {
            this.addBrowseSelectionListener(selectionListener);
        }
    }

    public void addAll(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            ((Combo)this.mField).add(stringArray[i]);
            this.mItems.add(stringArray[i]);
        }
    }

    public void add(String string, String string2, int n) {
        if (!this.mTranslations.containsKey(string)) {
            this.mTranslations.put(string, string2);
            if (n >= 0) {
                ((Combo)this.mField).add(string, n);
                this.mItems.add(n, string);
            } else {
                ((Combo)this.mField).add(string);
                this.mItems.add(string);
            }
        }
    }

    public void add(String string, String string2) {
        this.add(string, string2, -1);
    }

    public void add(String string, int n) {
        this.add(string, string, n);
    }

    public void add(String string) {
        this.add(string, string, -1);
    }

    public void remove(String string) {
        this.mTranslations.remove(string);
        ((Combo)this.mField).remove(string);
        this.mItems.remove(string);
    }

    public void remove(int n) {
        this.remove(this.getItem(n));
    }

    public void remove(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.remove(i);
        }
    }

    public void removeAll() {
        this.mTranslations.clear();
        ((Combo)this.mField).removeAll();
        this.mItems.clear();
    }

    public void select(int n) {
        ((Combo)this.mField).select(n);
        this.mSelected = n;
        FieldEvent fieldEvent = new FieldEvent(this.mProperty, this.getValue());
        this.fireFieldChangedEvent(fieldEvent);
    }

    public void select(String string) {
        int n = -1;
        Combo combo = (Combo)this.mField;
        for (int i = 0; i < combo.getItemCount() && -1 == n; ++i) {
            if (!this.getValue(i).equals(string)) continue;
            n = i;
        }
        combo.select(n);
        this.mSelected = n;
        this.fireFieldChangedEvent(new FieldEvent(this.mProperty, string));
    }

    @Deprecated
    public String getItem(int n) {
        return this.mItems.get(n);
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    @Override
    public String getValue() {
        String string = null;
        if (-1 != this.mSelected) {
            string = this.getValue(this.mSelected);
        }
        return string;
    }

    public String getValue(int n) {
        String string = null;
        if (n >= 0 && n < this.getItemCount()) {
            String string2;
            string = string2 = this.mItems.get(n);
            String string3 = this.mTranslations.get(string2);
            if (string3 != null) {
                string = string3;
            }
        }
        return string;
    }
}

