/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui.rows;

import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.LabeledRow;
import org.libreoffice.ide.eclipse.core.gui.rows.Messages;

public class FileRow
extends LabeledRow {
    private String mValue = new String();
    private boolean mDirectory = false;

    public FileRow(Composite composite, String string, String string2, boolean bl) {
        super(string);
        Label label = new Label(composite, 16416);
        label.setText(string2);
        Text text = new Text(composite, 2048);
        this.createContent(composite, (Control)label, (Control)text, Messages.getString("FileRow.Browse"), false);
        this.mField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FileRow.this.setValue(FileRow.this.getValue());
            }
        });
        this.addBrowseSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileRow.this.browse();
            }
        });
        this.mDirectory = bl;
    }

    protected void browse() {
        BusyIndicator.showWhile((Display)this.mBrowse.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                FileRow.this.doOpenFileSelectionDialog();
            }
        });
    }

    protected void doOpenFileSelectionDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String string = null;
        if (this.mDirectory) {
            DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
            String string2 = this.getValue();
            if (string2 != null) {
                directoryDialog.setText(Messages.getString("FileRow.DirectoryTitle"));
                string = directoryDialog.open();
            }
        } else {
            FileDialog fileDialog = new FileDialog(shell, 4096);
            String string3 = this.getValue();
            if (string3 != null) {
                fileDialog.setFileName(string3);
            }
            fileDialog.setText(Messages.getString("FileRow.FileTitle"));
            string = fileDialog.open();
        }
        if (string != null) {
            this.setValue(string);
        }
    }

    @Override
    public String getValue() {
        return this.mValue;
    }

    public void setValue(String string) {
        if (string.equals(((Text)this.mField).getText())) {
            return;
        }
        ((Text)this.mField).setText(string);
        this.mValue = string;
        FieldEvent fieldEvent = new FieldEvent(this.getProperty(), this.getValue());
        this.fireFieldChangedEvent(fieldEvent);
    }
}

