/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui.rows;

import java.text.MessageFormat;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;

public abstract class LabeledRow {
    public static final int LAYOUT_COLUMNS = 3;
    private static final int FIELD_WIDTH = 10;
    protected Control mLabel;
    protected Control mField;
    protected Control mBrowse;
    protected String mProperty;
    protected IFieldChangedListener mListener;

    public LabeledRow(String string) {
        this.mProperty = string;
    }

    public LabeledRow(Composite composite, String string, Control control, Control control2, String string2, boolean bl) {
        this.mProperty = string;
        this.createContent(composite, control, control2, string2, bl);
    }

    public void setTooltip(String string) {
        this.mField.setToolTipText(string);
    }

    public void setLabel(String string) {
        ((Label)this.mLabel).setText(string);
        this.mLabel.pack(true);
        this.mLabel.getParent().layout(true);
    }

    public String getLabel() {
        return ((Label)this.mLabel).getText();
    }

    public void addBrowseSelectionListener(SelectionListener selectionListener) {
        if (this.mBrowse instanceof Link) {
            ((Link)this.mBrowse).addSelectionListener(selectionListener);
        } else if (this.mBrowse instanceof Button) {
            ((Button)this.mBrowse).addSelectionListener(selectionListener);
        }
    }

    protected void createContent(Composite composite, Control control, Control control2, String string, boolean bl) {
        this.mLabel = control;
        this.mField = control2;
        if (null != string) {
            if (bl) {
                Link link = new Link(composite, 0);
                link.setLayoutData((Object)new GridData(3, 2, false, false));
                link.setFont(composite.getFont());
                String string2 = "<A>{0}</A>";
                String string3 = MessageFormat.format(string2, string);
                link.setText(string3);
                this.mBrowse = link;
            } else {
                Button button = new Button(composite, 8);
                button.setLayoutData((Object)new GridData(3, 2, false, false));
                button.setText(string);
                this.mBrowse = button;
            }
        }
        this.fillRow(composite);
    }

    public String getProperty() {
        return this.mProperty;
    }

    public abstract String getValue();

    protected void fillRow(Composite composite) {
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            int n = ((GridLayout)layout).numColumns - 1;
            if (this.mLabel != null) {
                this.mLabel.setLayoutData((Object)new GridData(4));
            }
            int n2 = n;
            if (this.mBrowse != null) {
                n2 = n - 1;
            }
            if (this.mLabel == null) {
                --n2;
            }
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = n2;
            gridData.grabExcessHorizontalSpace = 1 == n2;
            gridData.verticalAlignment = 4;
            gridData.widthHint = 10;
            this.mField.setLayoutData((Object)gridData);
            if (this.mBrowse != null) {
                this.mBrowse.setLayoutData((Object)new GridData(260));
            }
        }
    }

    public void setFieldChangedListener(IFieldChangedListener iFieldChangedListener) {
        this.mListener = iFieldChangedListener;
    }

    public void removeFieldChangedlistener() {
        this.mListener = null;
    }

    protected void fireFieldChangedEvent(FieldEvent fieldEvent) {
        if (null != this.mListener) {
            this.mListener.fieldChanged(fieldEvent);
        }
    }

    public void setVisible(boolean bl) {
        GridData gridData = (GridData)this.mLabel.getLayoutData();
        gridData.exclude = !bl;
        this.mLabel.setLayoutData((Object)gridData);
        gridData = (GridData)this.mField.getLayoutData();
        gridData.exclude = !bl;
        this.mField.setLayoutData((Object)gridData);
        if (null != this.mBrowse) {
            gridData = (GridData)this.mBrowse.getLayoutData();
            gridData.exclude = !bl;
            this.mBrowse.setLayoutData((Object)gridData);
        }
        this.mLabel.setVisible(bl);
        this.mField.setVisible(bl);
        if (this.mBrowse != null) {
            this.mBrowse.setVisible(bl);
        }
    }

    public void setEnabled(boolean bl) {
        this.mField.setEnabled(bl);
        if (null != this.mBrowse) {
            this.mBrowse.setEnabled(bl);
        }
    }
}

