/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.gui.rows;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.libreoffice.ide.eclipse.core.gui.rows.Messages;
import org.libreoffice.ide.eclipse.core.gui.rows.TextRow;
import org.libreoffice.ide.eclipse.core.unotypebrowser.InternalUnoType;
import org.libreoffice.ide.eclipse.core.unotypebrowser.UnoTypeBrowser;

public class TypeRow
extends TextRow {
    private InternalUnoType mSelectedType;
    private int mType = 0;
    private boolean mIncludeSequences = false;
    private boolean mIncludeSimpleTypes = false;
    private boolean mIncludeVoid = true;

    public TypeRow(Composite composite, String string, String string2, int n) {
        super(composite, string, string2);
        if (n >= 0 && n <= 2047) {
            this.mType = n;
        }
    }

    public void includeSequences(boolean bl) {
        this.mIncludeSequences = bl;
    }

    public void includeSimpleTypes(boolean bl) {
        this.mIncludeSimpleTypes = bl;
    }

    public void includeVoid(boolean bl) {
        this.mIncludeVoid = bl;
    }

    @Override
    protected void createContent(Composite composite, Control control, Control control2, String string, boolean bl) {
        super.createContent(composite, control, control2, Messages.getString("TypeRow.Browse"), true);
        ((Text)this.mField).addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && (keyEvent.stateMask & 0x40000) != 0) {
                    int n;
                    Text text = (Text)TypeRow.this.mField;
                    int n2 = text.getCaretPosition();
                    String string = text.getText(0, n2);
                    if ("sequence".startsWith(string.substring(n = TypeRow.this.getStartOfWord(n2, text.getText()), n2)) && TypeRow.this.mIncludeSequences) {
                        String string2 = "sequence".substring(n2 - n) + "<>";
                        text.insert(string2);
                        TypeRow.this.setValue(text.getText().trim());
                        text.setSelection(n2 + string2.length() - 1);
                        keyEvent.doit = false;
                    } else if (TypeRow.this.mIncludeSimpleTypes) {
                        String[] stringArray;
                        for (String string3 : stringArray = new String[]{"unsigned ", "string", "short", "long", "hyper", "double", "float", "any", "void", "char", "type", "boolean"}) {
                            if (string3.equals("void") && !TypeRow.this.mIncludeVoid || !string3.startsWith(string.substring(n, n2))) continue;
                            String string4 = string3.substring(n2 - n);
                            text.insert(string4);
                            TypeRow.this.setValue(text.getText().trim());
                            text.setSelection(n2 + string4.length());
                            keyEvent.doit = false;
                            break;
                        }
                    }
                }
            }
        });
        final Shell shell = composite.getShell();
        this.addBrowseSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                int n = TypeRow.this.mType & 0x7FFFFFFE;
                UnoTypeBrowser unoTypeBrowser = new UnoTypeBrowser(shell, n);
                unoTypeBrowser.setSelectedType(TypeRow.this.mSelectedType);
                if (0 == unoTypeBrowser.open()) {
                    TypeRow.this.mSelectedType = unoTypeBrowser.getSelectedType();
                    if (null != TypeRow.this.mSelectedType) {
                        Text text = (Text)TypeRow.this.mField;
                        int n2 = text.getCaretPosition();
                        text.insert(TypeRow.this.mSelectedType.getFullName().replaceAll("\\.", "::"));
                        text.setFocus();
                        text.setSelection(n2 + TypeRow.this.mSelectedType.getFullName().length());
                        TypeRow.this.setValue(text.getText().trim());
                    }
                }
            }
        });
    }

    private int getStartOfWord(int n, String string) {
        int n2;
        for (n2 = n - 1; string.charAt(n2) >= 'a' && string.charAt(n2) <= 'z' && n2 > 0; --n2) {
        }
        if (n2 != 0) {
            ++n2;
        }
        return n2;
    }
}

