/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;

public class ImageManager {
    private ResourceBundle mImageBundle;
    private ImageRegistry mRegistry = new ImageRegistry();

    public ImageManager() {
        try {
            this.mImageBundle = ResourceBundle.getBundle("org.libreoffice.ide.eclipse.core.i18n.ImageManager");
        }
        catch (NullPointerException nullPointerException) {
            PluginLogger.debug("Call to getBundle is incorrect: NullPointerException caught");
        }
        catch (MissingResourceException missingResourceException) {
            String string = "Image file not found for locale :" + Locale.getDefault().toString();
            PluginLogger.error(string);
        }
    }

    public Image getImage(String string) {
        ImageDescriptor imageDescriptor;
        Image image = this.mRegistry.get(string);
        if (null == image && null != (imageDescriptor = this.getImageDescriptor(string))) {
            image = imageDescriptor.createImage();
            this.mRegistry.put(string, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = null;
        if (null != this.mImageBundle) {
            String string2 = this.mImageBundle.getString(string);
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.libreoffice.ide.eclipse.core", (String)string2);
        }
        return imageDescriptor;
    }

    public ImageDescriptor getImageDescriptorFromPath(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.libreoffice.ide.eclipse.core", (String)string);
    }
}

