/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.Messages;
import org.libreoffice.ide.eclipse.core.internal.model.OOo;
import org.libreoffice.ide.eclipse.core.internal.model.SDK;
import org.libreoffice.ide.eclipse.core.internal.model.URE;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;

public class PropertiesManager {
    private static final String SDKPATH_PREFERENCE_KEY = "sdkpath";
    private static final String SDKNAME_PREFERENCE_KEY = "sdkname";
    private static final String OOOPATH_PREFERENCE_KEY = "ooopath";
    private static final String OOONAME_PREFERENCE_KEY = "oooname";

    public static ISdk[] loadSDKs() {
        ISdk[] iSdkArray = null;
        try {
            Properties properties = PropertiesManager.getProperties();
            int n = 0;
            boolean bl = false;
            Vector<SDK> vector = new Vector<SDK>();
            do {
                String string = properties.getProperty(SDKPATH_PREFERENCE_KEY + n);
                String string2 = properties.getProperty(SDKNAME_PREFERENCE_KEY + n);
                bl = null != string;
                ++n;
                if (!bl) continue;
                try {
                    SDK sDK = new SDK(string, string2);
                    vector.add(sDK);
                }
                catch (InvalidConfigException invalidConfigException) {
                    PluginLogger.error(invalidConfigException.getLocalizedMessage(), invalidConfigException);
                }
            } while (bl);
            iSdkArray = new ISdk[vector.size()];
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                iSdkArray[i] = (ISdk)vector.get(i);
            }
            vector.clear();
        }
        catch (IOException iOException) {
            PluginLogger.error(Messages.getString("PropertiesManager.UnreadableFileError") + ".ooo_config", iOException);
        }
        return iSdkArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSDKs(ISdk[] iSdkArray) {
        FileOutputStream fileOutputStream = null;
        try {
            Object object;
            Properties properties = PropertiesManager.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith(SDKPATH_PREFERENCE_KEY) && !string.startsWith(SDKNAME_PREFERENCE_KEY)) continue;
                properties.remove(string);
            }
            for (int i = 0; i < iSdkArray.length; ++i) {
                object = iSdkArray[i];
                properties.put(SDKPATH_PREFERENCE_KEY + i, object.getHome());
                properties.put(SDKNAME_PREFERENCE_KEY + i, object.getName());
            }
            String string = OOEclipsePlugin.getDefault().getStateLocation().toString();
            object = new File(string + "/" + ".ooo_config");
            if (!((File)object).exists()) {
                ((File)object).createNewFile();
            }
            fileOutputStream = new FileOutputStream((File)object);
            properties.store(fileOutputStream, "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            PluginLogger.error(fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            PluginLogger.error(iOException.getLocalizedMessage(), iOException);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static IOOo[] loadOOos() {
        IOOo[] iOOoArray = null;
        try {
            Properties properties = PropertiesManager.getProperties();
            int n = 0;
            boolean bl = false;
            Vector<IOOo> vector = new Vector<IOOo>();
            do {
                String string = properties.getProperty(OOOPATH_PREFERENCE_KEY + n);
                String string2 = properties.getProperty(OOONAME_PREFERENCE_KEY + n);
                bl = null != string;
                ++n;
                if (!bl) continue;
                try {
                    OOo oOo = new OOo(string, string2);
                    vector.add(oOo);
                }
                catch (InvalidConfigException invalidConfigException) {
                    PropertiesManager.addURE(string, string2, vector);
                }
            } while (bl);
            iOOoArray = new IOOo[vector.size()];
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                iOOoArray[i] = vector.get(i);
            }
            vector.clear();
        }
        catch (IOException iOException) {
            PluginLogger.error(Messages.getString("PropertiesManager.UnreadableFileError") + ".ooo_config", iOException);
        }
        return iOOoArray;
    }

    private static void addURE(String string, String string2, Vector<IOOo> vector) {
        try {
            URE uRE = new URE(string, string2);
            vector.add(uRE);
        }
        catch (InvalidConfigException invalidConfigException) {
            PluginLogger.error(invalidConfigException.getLocalizedMessage(), invalidConfigException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOOos(IOOo[] iOOoArray) {
        FileOutputStream fileOutputStream = null;
        try {
            Object object;
            Properties properties = PropertiesManager.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith(OOOPATH_PREFERENCE_KEY) && !string.startsWith(OOONAME_PREFERENCE_KEY)) continue;
                properties.remove(string);
            }
            for (int i = 0; i < iOOoArray.length; ++i) {
                object = iOOoArray[i];
                properties.put(OOOPATH_PREFERENCE_KEY + i, object.getHome());
                properties.put(OOONAME_PREFERENCE_KEY + i, object.getName());
            }
            String string = OOEclipsePlugin.getDefault().getStateLocation().toString();
            object = new File(string + "/" + ".ooo_config");
            if (!((File)object).exists()) {
                ((File)object).createNewFile();
            }
            fileOutputStream = new FileOutputStream((File)object);
            properties.store(fileOutputStream, "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            PluginLogger.error(fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            PluginLogger.error(iOException.getLocalizedMessage(), iOException);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() throws IOException {
        Properties properties = new Properties();
        String string = OOEclipsePlugin.getDefault().getStateLocation().toString();
        File file = new File(string + "/" + ".ooo_config");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.load(fileInputStream);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }
}

