/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;

public final class UnoSkeletonHelper {
    public static boolean supportPassiveRegistration(IUnoidlProject iUnoidlProject, String string, IProgressMonitor iProgressMonitor) {
        String string2 = "0.4";
        Process process = iUnoidlProject.getSdk().runTool(iUnoidlProject, string + " --version", iProgressMonitor);
        try {
            String string3 = UnoSkeletonHelper.readErrorStream(process);
            string2 = string3.substring(string3.lastIndexOf(32) + 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2.compareTo("0.5") > -1;
    }

    public static String readErrorStream(Process process) throws IOException {
        String string = null;
        try (InputStream inputStream = process.getErrorStream();
             Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");){
            if (scanner.hasNext()) {
                string = scanner.next().trim();
            }
        }
        return string;
    }

    public static void cleanupJavaSkeleton(IFile iFile, String string, IProgressMonitor iProgressMonitor) {
        try {
            Document document = UnoSkeletonHelper.removeUnneededCode(iFile, iProgressMonitor);
            Files.writeString(iFile.getLocation().toPath(), (CharSequence)document.get(), new OpenOption[0]);
        }
        catch (IOException | IllegalArgumentException | JavaModelException | BadLocationException | MalformedTreeException throwable) {
            PluginLogger.error("UnoSkeletonHelper.cleanupJavaSkeleton ERROR", throwable);
        }
    }

    private static Document removeUnneededCode(IFile iFile, IProgressMonitor iProgressMonitor) throws MalformedTreeException, BadLocationException, JavaModelException, IllegalArgumentException {
        ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)iFile);
        Document document = new Document(iCompilationUnit.getSource());
        CompilationUnit compilationUnit = UnoSkeletonHelper.getCompilationUnit(iCompilationUnit, iProgressMonitor);
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
        for (ImportDeclaration importDeclaration : ImportDeclarationFinder.perform((ASTNode)compilationUnit)) {
            aSTRewrite.remove((ASTNode)importDeclaration, null);
        }
        for (MethodDeclaration methodDeclaration : MethodDeclarationFinder.perform((ASTNode)compilationUnit)) {
            aSTRewrite.remove((ASTNode)methodDeclaration, null);
        }
        TextEdit textEdit = aSTRewrite.rewriteAST();
        textEdit.apply((IDocument)document);
        return document;
    }

    private static CompilationUnit getCompilationUnit(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) {
        ASTParser aSTParser = ASTParser.newParser((int)AST.getJLSLatest());
        aSTParser.setKind(8);
        aSTParser.setResolveBindings(true);
        aSTParser.setBindingsRecovery(true);
        aSTParser.setSource(iCompilationUnit);
        return (CompilationUnit)aSTParser.createAST(iProgressMonitor);
    }

    private static final class ImportDeclarationFinder
    extends ASTVisitor {
        private final List<ImportDeclaration> mImports = new ArrayList<ImportDeclaration>();

        private ImportDeclarationFinder() {
        }

        public static List<ImportDeclaration> perform(ASTNode aSTNode) {
            ImportDeclarationFinder importDeclarationFinder = new ImportDeclarationFinder();
            aSTNode.accept((ASTVisitor)importDeclarationFinder);
            return importDeclarationFinder.getImports();
        }

        public boolean visit(ImportDeclaration importDeclaration) {
            String string = importDeclaration.getName().getFullyQualifiedName();
            if (!string.endsWith("XComponentContext") && !string.endsWith("WeakBase")) {
                this.mImports.add(importDeclaration);
            }
            return super.visit(importDeclaration);
        }

        public List<ImportDeclaration> getImports() {
            return Collections.unmodifiableList(this.mImports);
        }
    }

    private static final class MethodDeclarationFinder
    extends ASTVisitor {
        private final List<MethodDeclaration> mMethods = new ArrayList<MethodDeclaration>();

        private MethodDeclarationFinder() {
        }

        public static List<MethodDeclaration> perform(ASTNode aSTNode) {
            MethodDeclarationFinder methodDeclarationFinder = new MethodDeclarationFinder();
            aSTNode.accept((ASTVisitor)methodDeclarationFinder);
            return methodDeclarationFinder.getMethods();
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            if (methodDeclaration.getName().getIdentifier().startsWith("__")) {
                this.mMethods.add(methodDeclaration);
            }
            return super.visit(methodDeclaration);
        }

        public List<MethodDeclaration> getMethods() {
            return Collections.unmodifiableList(this.mMethods);
        }
    }
}

